package com.transsion.xuanniao.account.comm.utils;

import android.text.TextUtils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @Description:
 * @author： HuNan on 2020/6/17
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class FormatUtils {

    public static boolean checkPwd(String pwd){
        return pwd.matches("^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{8,16}$");
    }

    public static String markPhone(String phone){
        try {
            if (phone == null || "".equals(phone)) return "";
            if (phone.contains("-")){
                String[] ss = phone.split("-");
                if (ss[1].length() < 6){
                    return phone;
                }
                return "+" + ss[0] + " " + ss[1].substring(0, 3)+"***"+ss[1].substring(ss[1].length() - 2);
            }else {
                if (phone.length() < 6){
                    return phone;
                }
                return phone.substring(0, 3)+"***"+phone.substring(phone.length() - 2);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return phone;
    }

    public static String markEmail(String email){
        try {
            if (email == null || "".equals(email) || email.indexOf("@") <= 0) return "";
            String[] ss = email.split("@");
            if (ss[0].length() < 3){
                return ss[0].charAt(0)+"***"+ss[1];
            }
            return ss[0].substring(0, 3)+"***@"+ss[1];
        }catch (Exception e){
            e.printStackTrace();
        }
        return email;
    }

    public static boolean checkEmail(String email){
//        String emailRule = "^([A-Za-z0-9_\\-.])+@([A-Za-z0-9_\\-])+\\.([A-Za-z]{2,6})$";
        String emailRule = "^([A-Za-z0-9_\\-.])+@([A-Za-z0-9_\\-])+\\.(([A-Za-z])+\\.)?([A-Za-z]{2,6})$";
        return email.matches(emailRule);
    }

    public static String stampToDate(long stamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(stamp);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static boolean isNotEmpty(String value){
        return value != null && !"".equals(value);
    }

    public static boolean checkPhone(String phone){
        if (TextUtils.isEmpty(phone)){
            return false;
        }
        String phoneRule = "^[0-9]{3,15}$";
        return phone.matches(phoneRule);
    }
    public static boolean isEmailOrPhone(String value){
        return checkEmail(value) || checkPhone(value);
    }

    public static boolean checkRealPhone(String phone){
        if (TextUtils.isEmpty(phone)){
            return false;
        }
        String phoneRule = "^[0-9]{6,15}$";
        return phone.matches(phoneRule);
    }
}
