package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.text.TextUtils;
import android.widget.TextView;

import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.xuanniao.account.R;

/**
 * @Description:
 * @author： 胡南 on 2021/4/25
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class LoadingDialog {
    private PromptDialog promptDialog;

    public void showLoading(Context context,String msg){

        if (promptDialog == null){
            promptDialog = new PromptDialog.Builder(context,R.style.dialog_soft_input)
                    .setView(R.layout.xn_loading_dialog)
                    .setCanceledOnTouchOutside(false)
                    .show();
        }else {
            if (!promptDialog.isShowing()){
                promptDialog.show();
            }
        }
        TextView content = promptDialog.findViewById(R.id.content);
        if (TextUtils.isEmpty(msg)){
            content.setText("");
        }else {
            content.setText(msg);
        }
    }

    public boolean isShowing(){
        if (promptDialog != null){
            return promptDialog.isShowing();
        }
        return false;
    }
    public void hide(){
        if (promptDialog != null && promptDialog.isShowing()){
            promptDialog.dismiss();
        }
    }
}