package com.transsion.xuanniao.account.comm.widget;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.transsion.xuanniao.account.R;

/**
 * @Description:
 * @author： 胡南 on 2021/5/25
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class NoWifiPage extends FrameLayout {
    private Reload reload;
    private boolean isShow;
    public NoWifiPage(@NonNull Context context) {
        super(context);
        init();
    }

    public NoWifiPage(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public NoWifiPage(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init(){
        LayoutInflater inflater = (LayoutInflater) getContext()
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        inflater.inflate(R.layout.xn_no_wifi_page, this, true);
        findViewById(R.id.reLoading).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (reload != null){
                    reload.onReload();
                }
            }
        });
    }

    public void setReload(Reload reload){
        this.reload = reload;
    }

    public interface Reload{
        void onReload();
    }

    public void show(Activity activity){
        if (!isShow){
            ViewGroup view =  activity.findViewById(android.R.id.content);
            view.addView(this, RelativeLayout.LayoutParams.MATCH_PARENT,RelativeLayout.LayoutParams.MATCH_PARENT);
            isShow = true;
        }

    }

    public void dismiss(Activity activity){
        if (isShow){
            ViewGroup view =  activity.findViewById(android.R.id.content);
            view.removeView(this);
            isShow = false;
        }
    }
}