package com.transsion.xuanniao.account.api;

import android.content.Context;

import com.transsion.xuanniao.account.comm.utils.AppUtils;

import java.util.HashMap;

/**
 * @Description:
 * @author： 胡南 on 2021/4/16
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class XNApiManager {
    private String clientId = "palmid";
    private int envMode = EnvMode.DEVELOP;
    private HashMap<String,String> googleClientIds = new HashMap<>();
    private boolean isPalmIdApp = false;  // 区分PalmApp和PalmSDK
    private IPalmIdAppJob palmIdAppJob;

    private XNApiManager(){

    }

    static class SingletonInnerHolder {
        static XNApiManager instance = new XNApiManager();
    }
    public static XNApiManager instance(){
        return SingletonInnerHolder.instance;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getEnvMode() {
        return envMode;
    }

    public void setEnvMode(int envMode) {
        this.envMode = envMode;
    }

    public void setPalmIdApp(boolean isPalmIdApp) {
        this.isPalmIdApp = isPalmIdApp;
    }

    public boolean isPalmIdApp() {
        return isPalmIdApp;
    }

    public void setPalmIdAppJob(IPalmIdAppJob palmIdAppJob) {
        this.palmIdAppJob = palmIdAppJob;
    }

    public IPalmIdAppJob getPalmIdAppJob() {
        return palmIdAppJob;
    }
}
