package com.transsion.xuanniao.account.comm.prefs;

import android.content.Context;
import android.content.SharedPreferences;

public class BasePrefs {
    private SharedPreferences prefs;
    private SharedPreferences.Editor editor;

    public BasePrefs(Context context, String prefsName) {
        prefs = context.getSharedPreferences(prefsName, Context.MODE_PRIVATE);
    }

    protected boolean getBoolean(String key, boolean defValue) {
        return prefs.getBoolean(key, defValue);
    }

    protected float getFloat(String key, float defValue) {
        return prefs.getFloat(key, defValue);
    }

    protected int getInt(String key, int defValue) {
        return prefs.getInt(key, defValue);
    }

    protected long getLong(String key, long defValue) {
        return prefs.getLong(key, defValue);
    }

    public String getString(String key, String defValue) {
        return prefs.getString(key, defValue);
    }

    protected void putBoolean(String key, boolean v) {
        ensureEditorAvailability();
        editor.putBoolean(key, v);
    }

    protected void putFloat(String key, float v) {
        ensureEditorAvailability();
        editor.putFloat(key, v);
    }

    protected void putInt(String key, int v) {
        ensureEditorAvailability();
        editor.putInt(key, v);
    }

    protected void putLong(String key, long v) {
        ensureEditorAvailability();
        editor.putLong(key, v);
    }

    public void putString(String key, String v) {
        ensureEditorAvailability();
        editor.putString(key, v);
    }

    public void save() {
        if (editor != null) {
            editor.apply();
        }
    }

    protected void ensureEditorAvailability() {
        if (editor == null) {
            editor = prefs.edit();
        }
    }

    public void clear() {
        ensureEditorAvailability();
        editor.clear();
        save();
    }
    public void remove(String key){
        ensureEditorAvailability();
        editor.remove(key);
    }
}
