package com.transsion.xuanniao.account.comm.prefs;

import android.content.Context;

import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.api.XNApiManager;

import org.json.JSONObject;

/**
 * @Description:
 * @author： HuNan on 2020/5/14
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class ClientPrefs extends BasePrefs {
    private static final String PREFS_NAME = "AccountPrefs";
    private final String PKG_SIGN = "pkg_sign";
    private final String IS_LOGGED_IN = "is_logged_in";
    private final String DEVICE_NO = "device_no";
    private final String COUNTRY_CODE = "country_code";
    private final String COUNTRY_NAME = "country_name";
    private final String LOGIN_NAME = "login_name";
    private final String LAST_LOGIN_REQ = "last_login_req";
    private final String ACCOUNT_INFO = "account_info";
    private final String TOKEN_CONFIG = "token_config";
    private final String READ_QUICK = "read_quick";
    private final String KEY_PRIVACY_VERSION = "privacy_version";
    private final String KEY_USER_AGREEMENT_VERSION = "user_agreement_version";
    private final String KEY_PRIVACY_NEED_AGREE = "privacy_need_agree";
    private final String KEY_CLOSE_QUICK = "key_close_quick";
    private final String KEY_VERIFY_PWD_LIMIT = "key_verify_pwd_limit";
    private final String KEY_LOGIN_PWD_LIMIT = "key_login_pwd_limit";
    private final String KEY_CAPTCHA_LIMIT_LOGIN = "key_captcha_limit_login";
    private final String KEY_CAPTCHA_LIMIT_BIND = "key_captcha_limit_bind";
    private final String KEY_CAPTCHA_LIMIT_VERIFY = "key_captcha_limit_verify";
    private final String KEY_CAPTCHA_LIMIT_RESET_PWD = "key_captcha_limit_reset_pwd";
    private final String KEY_CLOUD_CONFIG = "key_cloud_config";
    private final String KEY_IS_LOGIN_TIME_OUT = "is_login_time_out";
    private final String KEY_LOGIN_TIME_OUT = "login_time_out";

//    private final String KEY_CODE_COUNT = "key_code_count";
    private final String KEY_BINDING_EMAIL_COUNT = "key_binding_email_count";
    private final String KEY_BINDING_PHONE_COUNT = "key_binding_phone_count";
    private final String KEY_LOGIN_COUNT = "key_login_count";
    private final String KEY_VERIFY_ACCOUNT = "key_verify_account";
    private final String KEY_VERIFY_EMAIL = "key_verify_email";
    private final String KEY_VERIFY_PHONE = "key_verify_phone";
    private final String KEY_TIME_DIFF = "key_time_diff";
    private final String KEY_STORE_INIT = "key_store_init";
    private final String KEY_DEVICE_ID = "key_device_id";
    private final String KEY_REFRESH_TIME = "key_refresh_time";
    private final String KEY_TUDC_RELOGIN = "key_tudc_relogin";
    private final String KEY_HAVE_AGREE_BRAND = "have_agree_brand";
    private final String KEY_SMS_TICKET = "sms_ticket";
    private final String KEY_EMS_TICKET = "ems_ticket";
    private Context context;
    public ClientPrefs(Context context, String prefsName) {
        super(context, prefsName);
        this.context = context;
    }
    public static ClientPrefs get(Context context){
        return new ClientPrefs(context.getApplicationContext(), PREFS_NAME);
    }

    public String getLoginName() {
        return getString(LOGIN_NAME, "loginName");
    }

    public String getPkgSign(){
        return getString(PKG_SIGN, "");
    }

    public void setPkgSign(String v){
        putString(PKG_SIGN, v);
    }
    public boolean getReadQuick(){
        if (!XNApiManager.instance().isPalmIdApp()) {  // PalmSDK不展示快速了解
            return true;
        }
        return getBoolean(READ_QUICK, false);
    }
    public void setReadQuick(boolean v){
        putBoolean(READ_QUICK, v);
    }

    public boolean getIsLoggedIn(){
        return getBoolean(IS_LOGGED_IN, false);
    }
    public void setIsLoggedIn(boolean v){
        putBoolean(IS_LOGGED_IN, v);
    }

    public boolean getHaveAgreeBrand(){
        return getBoolean(KEY_HAVE_AGREE_BRAND, false);
    }
    public void setHaveAgreeBrand(boolean v){
        putBoolean(KEY_HAVE_AGREE_BRAND, v);
    }

    public String getLastLoginReq() {
        return getString(LAST_LOGIN_REQ, "");
    }

    public void setLastLoginReq(int loginType, String account, int codeType) {
        String lastLoginReq = "";
        try {
            lastLoginReq = new JSONObject()
                    .put("lt", loginType)
                    .put("ac", account)
                    .put("ct", codeType).toString();
        } catch (Exception e) {
//            e.printStackTrace();
        }
        putString(LAST_LOGIN_REQ, lastLoginReq);
    }

    public String getDeviceNo(){
        return getString(DEVICE_NO, null);
    }
    public void setDeviceNo(String v){
        putString(DEVICE_NO, v);
    }

    public String getCountryCode(){
        return getString(COUNTRY_CODE, "");
    }
    public void setCountryCode(String v){
        putString(COUNTRY_CODE, v);
    }

    public String getCountryName(){
        return getString(COUNTRY_NAME, "");
    }
    public void setCountryName(String v){
        putString(COUNTRY_NAME, v);
    }
    public String getAccountInfo(){
        return getString(ACCOUNT_INFO,"");
    }

    public void setAccountInfo(String accountInfo) {
        putString(ACCOUNT_INFO, accountInfo);
    }

    public String getTokenConfig() {
        return getString(TOKEN_CONFIG, "");
    }

    public void setTokenConfig(String config) {
        putString(TOKEN_CONFIG, config);
    }

    public String getPrivacyVersion(){
        return getString(KEY_PRIVACY_VERSION, context.getString(R.string.xn_privacy_version));
    }
    public void setPrivacyVersion(String v){
        putString(KEY_PRIVACY_VERSION, v);
    }

    public String getUserAgreementVersion(){
        return getString(KEY_USER_AGREEMENT_VERSION, context.getString(R.string.xn_user_agreement_version));
    }
    public void setUserAgreementVersion(String v){
        putString(KEY_USER_AGREEMENT_VERSION, v);
    }

//    public boolean getPrivacyNeedAgree(){
//        return getBoolean(KEY_PRIVACY_NEED_AGREE, false);
//    }
//    public void setPrivacyNeedAgree(boolean v){
//        putBoolean(KEY_PRIVACY_NEED_AGREE, v);
//    }

    public boolean getCloseQuick(){
        return getBoolean(KEY_CLOSE_QUICK, false);
    }
    public void setCloseQuick(boolean v){
        putBoolean(KEY_CLOSE_QUICK, v);
    }

    public void setVerifyPwdLimit(long v){
        putLong(KEY_VERIFY_PWD_LIMIT, v);
    }

    public long getVerifyPwdLimit(){
        return getLong(KEY_VERIFY_PWD_LIMIT, 0);
    }

    public void setLoginPwdLimit(long v){
        putLong(KEY_LOGIN_PWD_LIMIT, v);
    }

    public long getLoginPwdLimit(){
        return getLong(KEY_LOGIN_PWD_LIMIT, 0);
    }

    public void setCaptchaLoginLimit(long v){
        putLong(KEY_CAPTCHA_LIMIT_LOGIN, v);
    }

    public long getCaptchaLoginLimit(){
        return getLong(KEY_CAPTCHA_LIMIT_LOGIN, 0);
    }

    public void setCaptchaVerifyLimit(long v){
        putLong(KEY_CAPTCHA_LIMIT_VERIFY, v);
    }

    public long getCaptchaVerifyLimit(){
        return getLong(KEY_CAPTCHA_LIMIT_VERIFY, 0);
    }

    public void setCaptchaResetPwdLimit(long v){
        putLong(KEY_CAPTCHA_LIMIT_RESET_PWD, v);
    }

    public long getCaptchaResetPwdLimit(){
        return getLong(KEY_CAPTCHA_LIMIT_RESET_PWD, 0);
    }

    public void setCaptchaBindLimit(long v){
        putLong(KEY_CAPTCHA_LIMIT_BIND, v);
    }

    public long getCaptchaBindLimit(){
        return getLong(KEY_CAPTCHA_LIMIT_BIND, 0);
    }

    public String getCloudConfig(){
        return getString(KEY_CLOUD_CONFIG, "");
    }
    public void setCloudConfig(String v){
        putString(KEY_CLOUD_CONFIG, v);
    }


    public boolean getIsLoginTimeOut(){
        return getBoolean(KEY_IS_LOGIN_TIME_OUT, false);
    }
    public void setIsLoginTimeOut(boolean v){
        putBoolean(KEY_IS_LOGIN_TIME_OUT, v);
    }

    public void setLoginTimeOut(long v){
        putLong(KEY_LOGIN_TIME_OUT, v);
    }

    public long getLoginTimeOut(){
        return getLong(KEY_LOGIN_TIME_OUT, 0);
    }


    public void setBindingEmailCount(long v){
        putLong(KEY_BINDING_EMAIL_COUNT, v);
    }

    public long getBindingEmailCount(){
        return getLong(KEY_BINDING_EMAIL_COUNT, 0);
    }

    public void setBindingPhoneCount(long v){
        putLong(KEY_BINDING_PHONE_COUNT, v);
    }

    public long getBindingPhoneCount(){
        return getLong(KEY_BINDING_PHONE_COUNT, 0);
    }

    public void setLoginCount(long v){
        putLong(KEY_LOGIN_COUNT, v);
    }

    public long getLoginCount(){
        return getLong(KEY_LOGIN_COUNT, 0);
    }

    public void setVerifyAccount(long v){
        putLong(KEY_VERIFY_ACCOUNT, v);
    }

    public long getVerifyAccount(){
        return getLong(KEY_VERIFY_ACCOUNT, 0);
    }

    public void setVerifyEmail(long v){
        putLong(KEY_VERIFY_EMAIL, v);
    }

    public long getVerifyEmail(){
        return getLong(KEY_VERIFY_EMAIL, 0);
    }

    public void setVerifyPhone(long v){
        putLong(KEY_VERIFY_PHONE, v);
    }

    public long getVerifyPhone(){
        return getLong(KEY_VERIFY_PHONE, 0);
    }
//    public void setCodeCount(int v){
//        putLong(KEY_CODE_COUNT, v);
//    }
//
//    public long getCodeCount(){
//        return getLong(KEY_CODE_COUNT, 100);
//    }

    public void setTimeDiff(long v){
        putLong(KEY_TIME_DIFF, v);
    }

    public long getTimeDiff(){
        return getLong(KEY_TIME_DIFF, 0);
    }

    public void setKeyStoreInit(boolean v){
        putBoolean(KEY_STORE_INIT, v);
    }
    public boolean getKeyStoreInit(){
        return getBoolean(KEY_STORE_INIT, false);
    }

    public void setDeviceId(String v){
        putString(KEY_DEVICE_ID, v);
    }

    public String getDeviceId(){
        return getString(KEY_DEVICE_ID, "");
    }

    public long getRefreshTime() {
        return getLong(KEY_REFRESH_TIME, 0);
    }

    public void setRefreshTime(long timestamp) {
        putLong(KEY_REFRESH_TIME, timestamp);
    }

    public void setTudcRelogin(boolean result) {
        putBoolean(KEY_TUDC_RELOGIN, result);
    }

    public boolean getTudcRelogin() {
        return getBoolean(KEY_TUDC_RELOGIN, false);
    }

    public void setSMSTicket(String v) {
        putString(KEY_SMS_TICKET, v);
    }

    public String getSMSTicket() {
        return getString(KEY_SMS_TICKET, "");
    }

    public void setEMSTicket(String v) {
        putString(KEY_EMS_TICKET, v);
    }

    public String getEMSTicket() {
        return getString(KEY_EMS_TICKET, "");
    }
}
