package com.transsion.xuanniao.account.comm.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.transsion.xuanniao.account.model.data.CloudItem;

import java.util.ArrayList;
import java.util.HashMap;

import tech.palm.lib.CommonConstants;

/**
 * @Description:
 * @author： 胡南 on 2021/6/3
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class AthenaUtils {

    public static String loginBy(boolean isByCode,boolean isPhone,boolean isEmail){
        if (isByCode){
            if (isPhone){
                return "PV";
            }else {
                return "EV";
            }
        }else {
            if (isPhone){
                return "PP";
            }else if (isEmail){
                return "EP";
            }else {
                return "IP";
            }
        }
    }

    public static int loginStatus(Context context){
//        AccountRes account = TeeManager.instance().getAccountInfo();
//        if (account == null || !ClientPrefs.get(context).getIsLoggedIn()){
//            return 0;
//        }else {
//            if (TextUtils.isEmpty(account.nickname) || TextUtils.isEmpty(account.avatarUrl)
//                    || !account.existPassword || (TextUtils.isEmpty(account.phone) && TextUtils.isEmpty(account.email))
//                    || !CloudUtils.isCloudSyncOn(context)){
//                return 2;
//            }
//        }
        return 1;
    }

    @SuppressLint("all")
    public static String synStatus(Context context){
        HashMap<String,Integer> synMap = new HashMap<>();
//        Cursor cursor = CloudUtils.getAllCloudSyncState(context);
//        if (cursor != null){
//            while (cursor.moveToNext()){
//                String state = cursor.getString(cursor.getColumnIndex(CloudItem.KEY_SYNC_STATE));
//                int category = Integer.parseInt(cursor.getString(cursor.getColumnIndex(CloudItem.KEY_CATEGORY)));
//                if (category == CommonConstants.CLOUD.DataType.CONTACT){
//                    synMap.put("Contacts", "true".equals(state) ? 1 : 0);
//                }else if (category == CommonConstants.CLOUD.DataType.BLOCKNUM){
//                    synMap.put("Block", "true".equals(state) ? 1 : 0);
//                }else if (category == CommonConstants.CLOUD.DataType.WLAN){
//                    synMap.put("WLAN", "true".equals(state) ? 1 : 0);
//                }
//            }
//        }
        Gson gson = new Gson();
        return gson.toJson(synMap);
    }

    public static int bindStatus(String value) {
        if (TextUtils.isEmpty(value)){
            return 0;
        }
        return 1;
    }

    public static String saveLocalData(ArrayList<CloudItem> items) {
        ArrayList<String> delCnt = new ArrayList<>();
        if (items != null){
            for (int i = 0; i < items.size(); i++) {
                if (items.get(i).select){
                    if (items.get(i).category == CommonConstants.CLOUD.DataType.CONTACT){
                        delCnt.add("Contacts");
                    }else if (items.get(i).category == CommonConstants.CLOUD.DataType.BLOCKNUM){
                        delCnt.add("Block");
                    }else if (items.get(i).category == CommonConstants.CLOUD.DataType.WLAN){
                        delCnt.add("WLAN");
                    }
                }
            }
        }
        if (delCnt.size() > 0){
            Gson gson = new Gson();
            return gson.toJson(delCnt);
        }
        return "";
    }

    public static String delCnt(int[] selects) {
        ArrayList<String> delCnt = new ArrayList<>();
        if (selects != null){
            for (int i = 0; i < selects.length; i++) {
                if (selects[i] == CommonConstants.CLOUD.DataType.CONTACT){
                    delCnt.add("Contacts");
                }else if (selects[i] == CommonConstants.CLOUD.DataType.BLOCKNUM){
                    delCnt.add("Block");
                }else if (selects[i] == CommonConstants.CLOUD.DataType.WLAN){
                    delCnt.add("WLAN");
                }
            }
        }
        if (delCnt.size() > 0){
            Gson gson = new Gson();
            return gson.toJson(delCnt);
        }
        return "";
    }

    public static String loginRecord(int loginType, String account, int codeType){
        if (loginType == 0){//邮箱或手机
            if (codeType == 0){//验证码登录
                if (account.contains("@")){//邮箱
                    return "EV";
                }else if (account.contains("-")){//手机
                    return "PV";
                }
            }else {//密码登录
                if (account.contains("@")){//邮箱
                    return "EP";
                }else if (account.contains("-")){//手机
                    return "PP";
                }else {//账号id
                    return "IP";
                }
            }
        }
        return "";
    }
}