package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

import com.transsion.core.utils.ScreenUtil;
import com.transsion.xuanniao.account.login.view.BehaviorVerifyDialog;

public class BehaviorImageView extends AppCompatImageView {

    private int mRadius;
    private Path mPath;
    private RectF mRectF;
    private ViewOutlineProvider viewOutlineProvider;
    private int mWidth, mHeight;
    private Paint mSlidePaint;
    private Bitmap mSlideBitmap;  // 滑动图，背景图
    private float mSlideScale, mSlideXPos, mSlideYPos;
    private Matrix mSlideMatrix;
    private int mType = -1;
    private ImageClickListener mClickListener;

    public interface ImageClickListener {
        void onTouch(float xPos, float yPos);  // 位置百分比
    }

    public BehaviorImageView(@NonNull Context context) {
        this(context, null);
    }

    public BehaviorImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BehaviorImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        mSlideMatrix = new Matrix();
        mSlidePaint = new Paint();
        mSlidePaint.setAntiAlias(true);
        setRadius(ScreenUtil.dip2px(6));  // 默认
    }

    public void setClickListener(ImageClickListener listener) {
        mClickListener = listener;
    }

    //更新图片圆角
    public void setRadius(int radius) {
        boolean isChange = radius != mRadius;
        mRadius = radius;
        if (mPath == null) {
            mPath = new Path();
        }
        if (mRectF == null) {
            mRectF = new RectF();
        }
        if (mRadius != 0) {
            if (Build.VERSION_CODES.LOLLIPOP <= Build.VERSION.SDK_INT) {
                if (viewOutlineProvider == null) {
                    viewOutlineProvider = new ViewOutlineProvider() {
                        @Override
                        public void getOutline(View view, Outline outline) {
                            int width = getWidth();
                            int height = getHeight();
                            outline.setRoundRect(0, 0, width, height, mRadius);
                        }
                    };
                }
                setOutlineProvider(viewOutlineProvider);
                setClipToOutline(true);
            }
            mRectF.set(0, 0, getWidth(), getHeight());
            mPath.reset();
            mPath.addRoundRect(mRectF, mRadius, mRadius, Path.Direction.CW);
        } else {
            if (Build.VERSION_CODES.LOLLIPOP <= Build.VERSION.SDK_INT) {
                setClipToOutline(false);
            }
        }

        if (isChange) {
            if (Build.VERSION_CODES.LOLLIPOP <= Build.VERSION.SDK_INT) {
                invalidateOutline();
            }
        }
    }

    /**
     * 设置类型和图片数据
     * @param slideYPos 滑块的左上角距离背景图的左上角的百分比
     */
    public void setData(int type, float slideYPos, Bitmap slideBitmap, Bitmap bgBitmap) {
        mType = type;
        mSlideBitmap = slideBitmap;
        if (bgBitmap != null) {
            mSlideScale = mWidth * 1f / bgBitmap.getWidth();  // 缩放比例
            mSlideYPos = slideYPos / 100 * bgBitmap.getHeight() * mSlideScale;
            setImageBitmap(bgBitmap);
        } else {
            setImageBitmap(null);  // 清空
        }
    }

    /**
     * 跟随滑块一起滑动
     * @param xPos
     */
    public void setXPos(float xPos) {
        mSlideXPos = xPos;
        invalidate();
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (mSlideBitmap != null) {
            mSlideMatrix.setScale(mSlideScale, mSlideScale);
            mSlideMatrix.postTranslate(mSlideXPos, mSlideYPos);
            canvas.drawBitmap(mSlideBitmap, mSlideMatrix, mSlidePaint);
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == MotionEvent.ACTION_UP) {  // 抬起
            if (mClickListener != null
                    && mType == BehaviorVerifyDialog.TYPE_SINGLE) {
                mClickListener.onTouch(event.getX() / mWidth, event.getY() / mHeight);
            }
        }
        return super.onTouchEvent(event);
    }

    @Override
    public void layout(int left, int top, int right, int bottom) {
        super.layout(left, top, right, bottom);
        mWidth = right - left;
        mHeight = bottom - top;
    }

    @Override
    public void draw(Canvas canvas) {
        boolean clip = false;
        if (Build.VERSION_CODES.LOLLIPOP > Build.VERSION.SDK_INT && mRadius > 0) {
            clip = true;
            canvas.save();
            canvas.clipPath(mPath);
        }
        super.draw(canvas);
        if (clip) {
            canvas.restore();
        }
    }
}
