package com.transsion.xuanniao.account.comm.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;

import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;

import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.utils.BitmapUtils;

/**
 * @Description:
 * @author： HuNan on 2020/6/18
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CaptchaCodeInput extends FrameLayout {
    private EditText edit;
    private ImageView captcha;
    private ICaptchaListener captchaListener;
    private String captchaBase64;
    public CaptchaCodeInput(Context context) {
        super(context);
    }

    public CaptchaCodeInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater) getContext()
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        inflater.inflate(R.layout.xn_view_captcha_input, this, true);
        initAttr(context.obtainStyledAttributes(attrs, R.styleable.InputView));
        initView();
    }

    private void initAttr(TypedArray array){
        String hint = array.getString(R.styleable.InputView_hint_resource);
        boolean showLine = array.getBoolean(R.styleable.InputView_show_line, true);
        View lineView = findViewById(R.id.line);
        lineView.setVisibility(showLine ? View.VISIBLE : INVISIBLE);
        if (hint != null && !hint.isEmpty()){
            EditText phoneEdit = findViewById(R.id.edit);
            phoneEdit.setHint(hint);
        }
        array.recycle();
    }

    private void initView(){
        edit = findViewById(R.id.edit);
        captcha = findViewById(R.id.captcha);
        captcha.setOnClickListener(new Click());
        edit.setOnFocusChangeListener(new FocusListener());
        if (getContext().getResources().getConfiguration().getLayoutDirection() == View.LAYOUT_DIRECTION_RTL){
            captcha.setScaleType(ImageView.ScaleType.FIT_START);
        }else {
            captcha.setScaleType(ImageView.ScaleType.FIT_END);
        }
    }
    public String getText(){
        return edit.getText().toString();
    }
    public void setText(String value){
        edit.setText(value);
    }
    public void addWatch(TextWatcher watcher){
        edit.addTextChangedListener(watcher);
    }

    public ICaptchaListener getCaptchaListener() {
        return captchaListener;
    }

    public void setCaptchaListener(ICaptchaListener captchaListener) {
        this.captchaListener = captchaListener;
    }

    public void setImageBitmap(String captchaBase64) {
        this.captchaBase64 = captchaBase64;
        captcha.setImageBitmap(BitmapUtils.base64ToBitmap(captchaBase64));
    }

    public void setImageResource(int id){
        captcha.setImageResource(id);
    }

    public EditText getEdit() {
        return edit;
    }

    class Click extends CustomClickListener{
        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.captcha){
                if (captchaListener != null){
                    captchaListener.onClick();
                }
            }
        }
    }

    class  FocusListener implements OnFocusChangeListener{
        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            View line = findViewById(R.id.line);
            int colorId = hasFocus ? R.color.xn_line_s : R.color.os_gray_secondary_color;
            line.setBackgroundColor(getResources().getColor(colorId));
            AppCompatImageView captchaLogo = findViewById(R.id.captchaLogo);
            Drawable drawable = captchaLogo.getDrawable();
            drawable.setTint(getResources().getColor(hasFocus ? R.color.xn_input_logo_color_s : R.color.xn_input_logo_color,null));
        }
    }
    public interface ICaptchaListener{
        void onClick();
    }

    public void setError(boolean error) {
        View line = findViewById(R.id.line);
        if (error) {
            line.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.os_red_basic_color));
        } else {
            line.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.os_gray_secondary_color));
        }
    }

    /**
     * 页面销毁缓存状态(切换深色模式)
     */
    public void saveState(Bundle outState) {
        if (!TextUtils.isEmpty(getText())) {
            outState.putString("cc_text", getText());
        }
        if (!TextUtils.isEmpty(captchaBase64)) {
            outState.putString("cc_captcha", captchaBase64);
        }
        outState.putInt("cc_visibility", getVisibility());
    }

    /**
     * 页面恢复之前状态(切换深色模式)
     */
    public void restoreState(Bundle inState) {
        if (inState != null) {
            if (inState.containsKey("cc_text")) {
                setText(inState.getString("cc_text"));
            }
            if (inState.containsKey("cc_captcha")) {
                setImageBitmap(inState.getString("cc_captcha"));
            }
            if (inState.containsKey("cc_visibility")) {
                setVisibility(inState.getInt("cc_visibility"));
            }
        }
    }
}
