package com.transsion.xuanniao.account.comm.widget;

import android.os.CountDownTimer;

/**
 * @Description:
 * @author： 胡南 on 2021/5/28
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CountHelper {
    private CountDownTimer countDownTimer;
    private long millisInFuture = 5*60*1000;
    private long countDownInterval = 1000;
    private boolean isCounting = false;
    private CountListener listener;

    public CountHelper(CountListener listener){
        this.listener = listener;
    }

    public void init(long millisInFuture){
        this.millisInFuture = millisInFuture;
    }
    public void startCount(){
        if (countDownTimer == null){
            countDownTimer = new CountDownTimer(millisInFuture,countDownInterval) {
                @Override
                public void onTick(long millisUntilFinished) {
                    if (listener != null){
                        listener.onTick(millisUntilFinished);
                    }
                }

                @Override
                public void onFinish() {
                    isCounting = false;
                    if (listener != null){
                        listener.countFinish();
                    }
                }
            };
        }
        isCounting = true;
        countDownTimer.start();
    }

    public void clearCount(){
        if (countDownTimer != null){
            countDownTimer.cancel();
            countDownTimer = null;
        }
        isCounting = false;
    }

    public boolean isCounting() {
        return isCounting;
    }

    public interface CountListener{
        void countFinish();
        void onTick(long millisUntilFinished);
    }
}