package com.transsion.xuanniao.account.login.view;

import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.ListView;

import com.transsion.effectengine.bounceeffect.OverScrollDecorHelper;
import com.transsion.widgetslib.util.search.SearchAnimManager;
import com.transsion.widgetslib.widget.SearchBar;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.login.presenter.CountryPresenter;
import com.transsion.xuanniao.account.login.presenter.ICountryView;
import com.transsion.xuanniao.account.model.data.CountryData;

import java.util.ArrayList;

import static com.transsion.xuanniao.account.comm.constant.DataKeys.KEY_COUNTRY_CODE;
import static com.transsion.xuanniao.account.comm.constant.DataKeys.KEY_COUNTRY_NAME;

/**
 * @Description:
 * @author： 胡南 on 2021/4/24
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CountrySelectActivity extends BaseActivity implements ICountryView {
    public static final String KEY_NOT_SHOW_CODE = "notShowCode";
    public static final String KEY_CC = "key_cc";
    public static final String KEY_NAME_EN = "key_name_en";
    public static final String KEY_NAME = "key_name";
    private CountryListAdapter adapter;
    private CountryPresenter presenter;
    private SearchBar mSearchbar;
//    private ArrayList<CountryData.Country> countries;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.xn_activity_country_select);
        presenter = new CountryPresenter();
        presenter.attachView(this);
        presenter.getCountriesFromCache();
//        countries = CountryData.getCountries();
        initView();
    }

    private void initView() {
        View contentView = findViewById(R.id.contentView);
        mSearchbar = findViewById(R.id.search_bar);
        if (SearchAnimManager.getInstance().getActionPolicy() == SearchAnimManager.POLICY_NOSEARCH_SEARCH) {
            SearchAnimManager.getInstance().setSecondPageSearchViews(mSearchbar, contentView);
            mSearchbar.post(() -> {
                SearchAnimManager.getInstance().enterSearch();
            });
        } else {
            mSearchbar.post(() -> {
                mSearchbar.startSearch();
            });
        }
        mSearchbar.setBackClickListener(v -> {
            finish();
        });
        boolean showCode = getIntent().getBooleanExtra(KEY_NOT_SHOW_CODE, false);
        if (showCode) {
            mSearchbar.setHint(getString(R.string.xn_country_region_hint));
        } else {
            mSearchbar.setHint(getString(R.string.xn_country_hint));
        }
        mSearchbar.getEditText().setTextDirection(View.TEXT_DIRECTION_LOCALE);
        mSearchbar.addTextWatcher(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int count) {
                LogUtils.d("onTextChanged charSequence = " + charSequence);
                if (adapter != null) {
                    ArrayList<CountryData.Country> filters = filter(charSequence.toString());
                    adapter.setCountries(filters);
                }
            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                finish();
                break;
        }
        return super.onOptionsItemSelected(item);
    }

    private void initList(ArrayList<CountryData.Country> countries){
        ListView listView = findViewById(R.id.listView);
        adapter = new CountryListAdapter(this,countries);
        adapter.setNotShowCode(getIntent().getBooleanExtra(KEY_NOT_SHOW_CODE,false));
        adapter.setSelected(getIntent().getStringExtra(KEY_COUNTRY_CODE),getIntent().getStringExtra(KEY_COUNTRY_NAME));
        listView.setAdapter(adapter);
        listView.setSelection(adapter.getSelectIndex());
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                adapter.setSelected(position);
            }
        });
        adapter.setOnSelect(new CountryListAdapter.OnSelect() {
            @Override
            public void select(int position) {
                CountryData.Country country = (CountryData.Country) adapter.getItem(position);
                Intent intent = new Intent();
                intent.putExtra(KEY_CC, country.code);
                intent.putExtra(KEY_NAME,country.displayName);
                intent.putExtra(KEY_NAME_EN,country.country);
                setResult(RESULT_OK, intent);
                finish();
            }
        });
        OverScrollDecorHelper.setUpOverScroll(listView);
    }

    private ArrayList<CountryData.Country> filter(String key){
        if (presenter.getCountries() == null){
            return null;
        }
        if (TextUtils.isEmpty(key)){
            return presenter.getCountries();
        }
        ArrayList<CountryData.Country> content = new ArrayList<>();

        for (CountryData.Country item : presenter.getCountries()) {
            if (item.displayName.toLowerCase().contains(key.toLowerCase()) ||
                    item.country.toLowerCase().contains(key.toLowerCase()) ||
                    item.code.toLowerCase().contains(key.toLowerCase())){
                content.add(item);
            }
        }

        return content;
    }

    /*********************************************************************************************
     * ICountryView Interface implementation start
     *********************************************************************************************/
    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public void fillDataToPage(ArrayList<CountryData.Country> countries) {
        if (adapter == null){
            initList(countries);
        }else {
            adapter.setCountries(countries);
        }
    }

    /*********************************************************************************************
     * ICountryView Interface implementation end
     *********************************************************************************************/

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (presenter != null){
            presenter.detachView();
        }
    }
}