package com.transsion.xuanniao.account.login.view;

import static com.transsion.xuanniao.account.comm.constant.DataKeys.KEY_COUNTRY_CODE;
import static com.transsion.xuanniao.account.comm.constant.DataKeys.KEY_COUNTRY_NAME;
import static com.transsion.xuanniao.account.login.view.CountrySelectActivity.KEY_CC;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ScrollView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.transsion.athenacust.AthenaCust;
import com.transsion.effectengine.bounceeffect.OverScrollDecorHelper;
import com.transsion.palmsdk.PalmAuthParam;
import com.transsion.palmsdk.PalmID;
import com.transsion.palmsdk.auth.PalmAuthManager;
import com.transsion.palmsdk.data.PalmAuthRequest;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.xuanniao.account.BuildConfig;
import com.transsion.xuanniao.account.R;
import com.transsion.xuanniao.account.api.XNApiManager;
import com.transsion.xuanniao.account.comm.constant.DataKeys;
import com.transsion.xuanniao.account.comm.constant.GlobalConstant;
import com.transsion.xuanniao.account.comm.constant.PalmsKeys;
import com.transsion.xuanniao.account.comm.mvpbase.BaseActivity;
import com.transsion.xuanniao.account.comm.net.NetworkConstants;
import com.transsion.xuanniao.account.comm.prefs.ClientPrefs;
import com.transsion.xuanniao.account.comm.tee.TeeManager;
import com.transsion.xuanniao.account.comm.utils.AthenaUtils;
import com.transsion.xuanniao.account.comm.utils.FormatUtil;
import com.transsion.xuanniao.account.comm.utils.FormatUtils;
import com.transsion.xuanniao.account.comm.utils.LanguageUtils;
import com.transsion.xuanniao.account.comm.utils.LogUtils;
import com.transsion.xuanniao.account.comm.utils.NetUtils;
import com.transsion.xuanniao.account.comm.utils.OSUtils;
import com.transsion.xuanniao.account.comm.widget.AccountInput;
import com.transsion.xuanniao.account.comm.widget.BehaviorVerifyInput;
import com.transsion.xuanniao.account.comm.widget.CaptchaCodeInput;
import com.transsion.xuanniao.account.comm.widget.CustomClickListener;
import com.transsion.xuanniao.account.comm.widget.ErrorView;
import com.transsion.xuanniao.account.comm.widget.SmsCodeInput;
import com.transsion.xuanniao.account.comm.widget.XNClickableSpan;
import com.transsion.xuanniao.account.comm.widget.XNLinkMovementMethod;
import com.transsion.xuanniao.account.help.view.WebViewActivity;
import com.transsion.xuanniao.account.login.presenter.ILoginView;
import com.transsion.xuanniao.account.login.presenter.LoginPresenter;
import com.transsion.xuanniao.account.model.data.AccountRes;
import com.transsion.xuanniao.account.model.data.BehaviorReq;
import com.transsion.xuanniao.account.model.data.BehaviorRes;
import com.transsion.xuanniao.account.model.data.BehaviorVerifyRes;
import com.transsion.xuanniao.account.model.data.CloudConfigRes;
import com.transsion.xuanniao.account.model.data.CountryData;
import com.transsion.xuanniao.account.model.data.LoginRes;
import com.transsion.xuanniao.account.model.data.PolicyRes;
import com.transsion.xuanniao.account.model.data.PrivacyAgreementMap;

import org.json.JSONObject;

import tech.palm.lib.athena.AthenaImpl;

/**
 * @Description:
 * @author： 胡南 on 2021/4/16
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class LoginActivity extends BaseActivity implements ILoginView {
    public static final int GOOGLE_SIGN_IN = 9001;
    private int reqCC = 1101;
    private int reqLoginSuccess = 1102;
    private LoginPresenter presenter;
    private AccountInput accountInput;
    private BehaviorVerifyInput verifyInput;
    private CaptchaCodeInput captchaInput;
    private SmsCodeInput codeInput;
    private CheckBox agreementCheck;
    private ErrorView loginByCodeError;
    private boolean isMainProcess = false;
    private Button loginOrRegister;
    private ViewGroup privacyL;
    private ScrollView scrollView;
    /**
     * 登录授权请求
     */
    private PalmAuthRequest palmAuthRequest;
    private boolean shouldShowEmailAssociation = false;
    private String verifyType = null;
    private BehaviorVerifyDialog verifyDialog;  // 行为验证

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        presenter = new LoginPresenter();
        presenter.attachView(this);
        presenter.setFinish(booleanExtra(DataKeys.IS_FINISH));

        if (CloudConfigRes.needRefresh(this)) {
            presenter.getCloudConfig();
        }
        String authRequestId = getIntent().getStringExtra(PalmsKeys.EXTRA_AUTH_REQUEST);
        if (savedInstanceState != null && TextUtils.isEmpty(authRequestId)) {
            authRequestId = savedInstanceState
                    .getString(PalmsKeys.EXTRA_AUTH_REQUEST, null);
        }
        palmAuthRequest = PalmAuthManager.getInstance(this).getAuthRequest(authRequestId);
        mainProcess();
    }

    private void mainProcess() {
        setContentView(R.layout.xn_activity_login);
        isMainProcess = true;
        initActionBar();
        initNote();
        init();
        initInput();
//        if (TextUtils.isEmpty(presenter.getImageTicket()) && NetUtils.instance().isNetworkConnected(this)) {
//            presenter.acquireCaptcha(null);
//        }
        if (TeeManager.instance().isTeeEnable()) {
            if (!TeeManager.instance().getIsKeyUploaded() && NetUtils.instance().isNetworkConnected(this)) {
                presenter.applyKey("");
            }
        }
        long pwdLimit = ClientPrefs.get(this).getLoginPwdLimit();
        if (pwdLimit > 0) {
            presenter.showFivePwdLimit(pwdLimit);
        }
        long captchaLimit = ClientPrefs.get(this).getCaptchaLoginLimit();
        if (captchaLimit > 0) {
            presenter.showCaptchaLimit(captchaLimit);
        }
        presenter.getCountriesFromCache();
    }

    private String getSource() {
        String source = stringExtra(DataKeys.KEY_SOURCE);
        if (TextUtils.isEmpty(source)) {
            source = "ExternalCall";
        }
        return source;
    }

    @SuppressLint({"StringFormatInvalid", "StringFormatMatches"})
    private void showSignOutTips(Context context) {

    }

    private void initActionBar() {
        ActionBar actionBar = getActionBar();
        actionBar.setDisplayOptions(
                ActionBar.DISPLAY_SHOW_CUSTOM, ActionBar.DISPLAY_SHOW_CUSTOM |
                        ActionBar.DISPLAY_SHOW_HOME | ActionBar.DISPLAY_SHOW_TITLE);
        actionBar.setCustomView(R.layout.xn_action_bar);
        actionBar.setDisplayHomeAsUpEnabled(true);
        TextView title = actionBar.getCustomView().findViewById(R.id.title);
//        title.setText(OSUtils.toBrandId(getString(R.string.xn_app_name)));
        title.setText("");
    }

    private void initNote() {
        String customizeApp = getString(R.string.sdk_lite_customize_app);

        TextView noteTitle = findViewById(R.id.noteTitle);
        noteTitle.setText(OSUtils.toBrandId(getString(R.string.sdk_text_login, customizeApp)));

        TextView loginTips = findViewById(R.id.tvLoginTips);
        loginTips.setText(getString(R.string.sdk_lite_customize_have_account, customizeApp));
    }

    @SuppressLint("StringFormatInvalid")
    private void init() {
        scrollView = findViewById(R.id.scrollView);
        loginOrRegister = findViewById(R.id.loginOrRegister);
        if (loginOrRegister != null) {
            loginOrRegister.setOnClickListener(new LoginClick());
        }

        agreementCheck = findViewById(R.id.agreementCheck);
        agreementCheck.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked){
                    AthenaImpl.getInstance(getContext()).enableAthena(true);  // 同意了隐私条款
                    ClientPrefs prefs = ClientPrefs.get(getContext());
                    AthenaImpl.getInstance(getContext()).authorizeCl(prefs.getPrivacyVersion(),
                            prefs.getUserAgreementVersion(), "", "", "");
                }
            }
        });

        // 定制跳转到业务方原有账号入口
        findViewById(R.id.tvLoginHere).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    String customizeIntent = getString(R.string.sdk_lite_customize_intent);
                    if (!TextUtils.isEmpty(customizeIntent)) {
                        Intent intent = new Intent();
                        if (customizeIntent.contains("/")) {
                            String[] splits = customizeIntent.split("/");
                            intent.setClassName(splits[0], splits[1]);
                        } else {
                            intent.setAction(customizeIntent);
                        }
                        startActivity(intent);
                        cancelAndFinish(true);
                    }
                } catch (Exception e) {
                    LogUtils.d(Log.getStackTraceString(e));
                }
            }
        });

        privacyL = findViewById(R.id.privacyL);
        showAgreement();
        OverScrollDecorHelper.setUpOverScroll(scrollView);
    }

    @Override
    protected boolean isShouldHideKeyboard(View v, MotionEvent event) {

        if (isClickView(agreementCheck, event)
                || (captchaInput != null && isClickView(captchaInput.getEdit(), event))
                || (accountInput != null && isClickView(accountInput.getEdit(), event))
                || (codeInput != null && isClickView(codeInput.getEdit(), event))
                || isClickView(privacyL, event)) {
            return false;
        }

        return true;
    }

    private void showAgreement() {
        TextView agreement = findViewById(R.id.agreement);
        String userAgreement = getString(R.string.xn_user_agreement);
        String privacyPolicy = getString(R.string.xn_privacy_policy);
        String and = getString(R.string.xn_and);
        String agreementPolicy = getRS(R.string.xn_agreement_privacy, userAgreement, privacyPolicy);

        if (!languageRight(agreementPolicy, userAgreement, privacyPolicy)){
            agreementPolicy = "I have read and agreed to the TECNO ID User Agreement and Privacy Policy";
            userAgreement = "User Agreement";
            privacyPolicy = "Privacy Policy";
        }

        agreementPolicy = OSUtils.toBrandId(agreementPolicy);

        SpannableString ss = new SpannableString(agreementPolicy + " ");
        int start = agreementPolicy.toLowerCase().indexOf(userAgreement.toLowerCase());
        try {
            ss.setSpan(new XNClickableSpan(this, new XNClickableSpan.ClickListen() {
                @Override
                public void onClick(@NonNull View widget) {
                    AthenaImpl.getInstance(getContext()).userAgreementCl();
                    String agreementUrl = PrivacyAgreementMap.getAgreementUrl(LanguageUtils.getLocalLanguage(getContext()));
                    if (TextUtils.isEmpty(agreementUrl)) {
                        presenter.getPolice(presenter.TAG_USAGE);
                    } else {
                        WebViewActivity.startActivity(LoginActivity.this,
                                R.string.xn_user_agreement, OSUtils.toBrandUrl(agreementUrl));
                    }
                }
            }), start, start + userAgreement.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            start = agreementPolicy.toLowerCase().indexOf(privacyPolicy.toLowerCase());
            ss.setSpan(new XNClickableSpan(this, new XNClickableSpan.ClickListen() {
                @Override
                public void onClick(@NonNull View widget) {
                    AthenaImpl.getInstance(getContext()).privacyPolicyCl();
                    String privacyUrl = PrivacyAgreementMap.getPrivacyUrl(LanguageUtils.getLocalLanguage(getContext()));
                    if (TextUtils.isEmpty(privacyUrl)) {
                        presenter.getPolice(presenter.TAG_POLICY);
                    } else {
                        WebViewActivity.startActivity(LoginActivity.this,
                                R.string.xn_privacy_policy, OSUtils.toBrandUrl(privacyUrl));
                    }
                }
            }), start, start + privacyPolicy.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        } catch (Exception e) {
            LogUtils.d(Log.getStackTraceString(e));
        }

        if (agreement != null) {
            agreement.setText(ss);
            agreement.setMovementMethod(XNLinkMovementMethod.getInstance());
        }
    }

    private boolean languageRight(String agreementPolicy,String userAgreement,String privacyPolicy){
        int start = agreementPolicy.toLowerCase().indexOf(userAgreement.toLowerCase());
        if (start == -1){
            return false;
        }
        start = agreementPolicy.toLowerCase().indexOf(privacyPolicy.toLowerCase());
        if (start == -1){
            return false;
        }
        return true;
    }

    private void initInput() {
        accountInput = findViewById(R.id.accountInput);
        captchaInput = findViewById(R.id.captchaInput);
        codeInput = findViewById(R.id.codeInput);
        loginByCodeError = findViewById(R.id.loginByCodeError);
        if (isOnlyPhoneNum()){
            accountInput.setOnlyPhoneNum();
        }
        accountInput.addWatch(new LoginWatch());
        captchaInput.addWatch(new LoginWatch());
        codeInput.addWatch(new LoginWatch());
        codeInput.setSmsCodeListener(new SmsCodeInput.ISmsCodeListener() {
            @Override
            public void getCode() {
                presenter.acquireCode(true);
            }

            @Override
            public void countFinish() {
                codeEnable();
            }
        });
        codeInput.setEditFocus(new SmsCodeInput.EditFocus() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && !TextUtils.isEmpty(getVerificationCode())) {
                    presenter.smsFillEnd();
                }
            }
        });
        accountInput.setInputListener(new AccountInput.IAccountInputListener() {
            @Override
            public void onSelectCc() {
                AthenaImpl.getInstance(getContext()).modifyMccCl(presenter.getCountryCode());
                Intent intent = new Intent(LoginActivity.this,CountrySelectActivity.class);
                intent.putExtra(KEY_COUNTRY_CODE, presenter.getCountryCode());
                intent.putExtra(KEY_COUNTRY_NAME,presenter.getCountryName());
                startActivityForResult(intent, reqCC);
                AthenaImpl.getInstance(getContext()).modifyMccShow();
            }
        });
        captchaInput.setCaptchaListener(new CaptchaCodeInput.ICaptchaListener() {
            @Override
            public void onClick() {
                if (presenter.isLoginByCode()) {
                    AthenaImpl.getInstance(getContext()).picVerifyCl();
                }
                if (!presenter.isShowCaptchaLimit()) {
                    showWaitDialog(getString(R.string.xn_loading));
                    presenter.acquireCaptcha(null, true);
                }
            }
        });
        accountInput.setEditFocus(new AccountInput.EditFocus() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                presenter.setLoginStart(System.currentTimeMillis());
            }
        });
        codeInput.startByEnd(ClientPrefs.get(this).getLoginCount());

        verifyInput = findViewById(R.id.verifyInput);
        verifyInput.setVerifyListener(new BehaviorVerifyInput.VerifyListener() {
            @Override
            public void showVerifyDialog() {
                if (verifyType == null) {
                    verifyType = System.currentTimeMillis() % 2 == 0
                            ? BehaviorReq.TYPE_SINGLE_CLICK : BehaviorReq.TYPE_SLIDE;  // 类型随机
                }
                if (verifyDialog == null) {
                    verifyDialog = new BehaviorVerifyDialog();
                    verifyDialog.setBehaviorListener(new BehaviorVerifyDialog.BehaviorListener() {
                        @Override
                        public void refreshClick() {
                            presenter.getBehaviorData(verifyType, false);

                            Bundle param = new Bundle();
                            param.putString("ti_s_type", verifyType);
                            AthenaImpl.getInstance(getContext())
                                    .trackAccountEvent("login_behavior_verify_refresh_cl", param);
                        }

                        @Override
                        public void startVerify(String data, String ticket, String resId) {
                            presenter.verifyBehavior(verifyType, data, ticket, resId);

                            Bundle param = new Bundle();
                            param.putString("ti_s_type", verifyType);
                            AthenaImpl.getInstance(getContext())
                                    .trackAccountEvent("login_behavior_verify_pop_cl", param);
                        }
                    });
                }
                presenter.getBehaviorData(verifyType, true);

                Bundle param = new Bundle();
                param.putString("ti_s_type", verifyType);
                AthenaImpl.getInstance(getContext())
                        .trackAccountEvent("login_behavior_verify_touch_cl", param);
            }
        });
    }

    /**
     * 使用上一次登录的信息填充界面
     */
    private void fillLastLoginReq() {
        int loginType = -1; // 0-手机号/邮箱/账号
        String account = "";
        int codeType = 0;  // 0-验证码 1-密码
        try {
            String lastLoginReq = ClientPrefs.get(this).getLastLoginReq();
            if (lastLoginReq.length() > 0) {
                JSONObject jsonObject = new JSONObject(lastLoginReq);
                loginType = jsonObject.getInt("lt");
                if (loginType == 0) {
                    account = jsonObject.getString("ac");
                    codeType = jsonObject.getInt("ct");
                }
                AthenaImpl.getInstance(this).loginShow(getSource(), AthenaUtils.loginRecord(loginType, account, codeType));
            }else {
                AthenaImpl.getInstance(this).loginShow(getSource(),null);
            }
        } catch (Exception e) {
//            e.printStackTrace();
            return;
        }
        if (loginType > 0) {

        } if (loginType == 0 && account.length() > 0) {
            if (account.contains("-") && !account.contains("@")) {   // 国家码-号码
                String[] texts = account.split("-");
                presenter.setCountryCode(texts[0]);  // 与请求参数保持一致
                accountInput.setCc(presenter.getCountryCodeWithPlus());
                accountInput.setText(texts[1]);
            } else {
                if (!isOnlyPhoneNum()){
                    accountInput.setText(account);
                }
            }
        }
    }

    @Override
    protected void onResume() {
        if (isMainProcess){
            if (accountInput != null
                    && accountInput.getEdit().hasFocus()
                    && accountInput.getType() == GlobalConstant.ACCOUNT_EMAIL
                    && shouldShowEmailAssociation){
                shouldShowEmailAssociation = false;
                accountInput.showEmailAssociation();
            }
        }
        super.onResume();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == reqCC) {
            if (resultCode == RESULT_OK) {
                presenter.setCountryCode(data.getStringExtra(KEY_CC));
                if (presenter.getCountryData() != null){
                    presenter.setCountryName(
                            CountryData.getEnName(getContext(),
                                    data.getStringExtra(CountrySelectActivity.KEY_NAME),
                                    presenter.getCountryData().countries));
                }

                AthenaImpl.getInstance(getContext()).selectMccCl(presenter.getCountryCode());
                accountInput.setCc(presenter.getCountryCodeWithPlus());
                ClientPrefs prefs = ClientPrefs.get(getContext());
                prefs.setCountryCode(presenter.getCountryCode());
                prefs.setCountryName(presenter.getCountryName());
                prefs.save();
            }
        } else if (requestCode == GOOGLE_SIGN_IN) {
//            Task<GoogleSignInAccount> task = GoogleSignIn.getSignedInAccountFromIntent(data);
//            handleGoogleLogin(task);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                cancelAndFinish(true);
                break;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (presenter != null) {
            presenter.clearCount();
            presenter.detachView();
        }
        if (codeInput != null) codeInput.clearCount();
    }

    /*********************************************************************************************
     * ILoginView Interface implementation start
     *********************************************************************************************/
    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public void showCaptcha(String captchaCode, String captchaBase64) {
        captchaInput.setImageBitmap(captchaBase64);

        if (TextUtils.isEmpty(captchaCode)) {
            captchaInput.setVisibility(View.VISIBLE);
        } else {
            captchaInput.setVisibility(View.GONE);
        }
        verifyInput.setVisibility(View.GONE);  // 隐藏行为验证按钮
        if (presenter.isCodeNeedCaptcha()) {
            AthenaImpl.getInstance(getContext()).picVerifyShow();
        }
        codeEnable();
        loginEnable();
    }

    @Override
    public void showCaptchaReduction() {
        captchaInput.setImageResource(R.drawable.xn_reduction);
    }

    @Override
    public String getAccount() {
        return accountInput.getText();
    }

    @Override
    public String getImageCaptcha() {
        return captchaInput.getText();
    }

    @Override
    public String getVerificationCode() {
        return codeInput.getText();
    }

    @Override
    public int getType() {
        return accountInput.getType();
    }

    @Override
    public void acquireCodeSuccess() {
        warning(getContext().getString(R.string.xn_sent));
        codeInput.clearCount();
        codeInput.startCount();
        codeInput.setGetCodeEnable(false);
        ClientPrefs prefs = ClientPrefs.get(this);
        prefs.setLoginCount(System.currentTimeMillis());
        prefs.save();
    }

    @Override
    public void updateVerifyView() {
        if (verifyInput.getVisibility() == View.VISIBLE) {
            verifyInput.setState(BehaviorVerifyInput.STATE_NORMAL);  // 重新点击验证
            loginEnable();  // 须重新点击验证
        } else {
            presenter.acquireCaptcha(null, true);  // 自动刷新图形验证码
        }
    }

    @Override
    public void getBehaviorResult(BehaviorRes behaviorRes, boolean showImage) {
        if (behaviorRes != null) {
            if (showImage) {
                verifyDialog.show(LoginActivity.this);

                Bundle param = new Bundle();
                param.putString("ti_s_type", verifyType);
                AthenaImpl.getInstance(getContext())
                        .trackAccountEvent("login_behavior_verify_pop_show", param);
            }
            Glide.with(getApplicationContext()).asBitmap().load(behaviorRes.bg).into(new SimpleTarget<Bitmap>() {
                @Override
                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    verifyDialog.setData(behaviorRes, resource);
                }
            });
        } else {
            warning(getString(R.string.xn_net_unavailable));
            if (verifyDialog.isShowing()) {
                verifyDialog.setData(null, null);
            }
        }
    }

    @Override
    public void verifyBehaviorResult(BehaviorVerifyRes verifyRes, int code) {
        if (code == 0) {
            if (verifyRes.result) {
                verifyInput.setState(BehaviorVerifyInput.STATE_SUCCESS);
                verifyDialog.dismiss();  // 弹框消失
                loginEnable();  // 刷新登录按钮状态
            } else {
                verifyInput.setState(BehaviorVerifyInput.STATE_FAILED);
                verifyDialog.resetWithError();
                presenter.getBehaviorData(verifyType, false);  // 失败自动刷新
            }
        } else {
            if (code == NetworkConstants.BEHAVIOR_VERIFY_OVER_LIMIT) {
                warning(getString(R.string.xn_behavior_over_limit));
                verifyDialog.dismiss();
            } else {
                warning(getString(R.string.xn_net_unavailable));
                verifyInput.setState(BehaviorVerifyInput.STATE_FAILED);
                verifyDialog.resetWithError();
            }
        }
        if (presenter.isLoginByCode()) {
            codeEnable();
        }
    }

    @Override
    public String getPwd() {
        return null;
    }

    @Override
    public void loginSuccess(String eventType, LoginRes result) {
        goNext(result);
        ClientPrefs prefs = ClientPrefs.get(this);
        prefs.setCountryCode(presenter.getCountryCode());
        prefs.setCountryName(presenter.getCountryName());
        if (!OSUtils.isOldPalmID) {  // 品牌ID登录解密
            prefs.setHaveAgreeBrand(true);  // 不再弹出品牌升级提示
        }
        prefs.save();

        SharedPreferences sp = getSharedPreferences(getPackageName(), Context.MODE_PRIVATE);
        String extPPV = sp.getString("ext_privacy_policy_version", "");
        String extUAV = sp.getString("ext_user_agreement_version", "");
        String extDPV = sp.getString("ext_developer_policy_version", "");
        AthenaImpl.getInstance(this).loginSuccess(prefs.getPrivacyVersion(),
                prefs.getUserAgreementVersion(), extPPV, extUAV, extDPV);
    }

    private void goNext(LoginRes loginRes) {
        isMainProcess = false;
        if (presenter.isFinish()) {
            setResult(RESULT_OK);
            if (palmAuthRequest != null) {
                Bundle result = new Bundle();
                try {
                    if (loginRes.account != null) {
                        result.putString(PalmsKeys.EXTRA_USER_INFO,
                                new JSONObject().put("nickName", loginRes.account.nickname)
                                        .put("userName", loginRes.account.username)
                                        .put("avatarUrl", loginRes.account.avatarUrl).toString());
                        result.putString(PalmsKeys.EXTRA_LINKED_ID,
                                String.valueOf(loginRes.account.xuanniaoId.hashCode()));
                        result.putString(PalmsKeys.EXTRA_LINKED_PKG, getPackageName());
                        result.putString(PalmsKeys.EXTRA_LINKED_BD, OSUtils.getBrandId());
                    }

                    result.putString(PalmsKeys.EXTRA_TOKEN_INFO,
                            new JSONObject().put("access_token", loginRes.token.accessToken)
                                    .put("refresh_token", loginRes.token.refreshToken)
                                    .put("open_id", loginRes.account != null ? loginRes.account.openId : "")
                                    .toString());
                } catch (Exception e) {
                    LogUtils.d(Log.getStackTraceString(e));
                }
                Bundle eparam = new Bundle();
                eparam.putString("appid", palmAuthRequest.getAuthParam().getAppid());
                eparam.putString("version", BuildConfig.SDK_VERSION);
                eparam.putString("result", "success");
                new AthenaCust("sdk_auth_result", 7710).trackCommon(eparam, null).submit();

                palmAuthRequest.setResult(result);
                palmAuthRequest = null;  // 避免onDestroy再次执行
            }
        }
        finish();
    }

    /**
     * 授权过程 + 用户主动取消
     */
    public void cancelAndFinish(boolean finish) {
        if (palmAuthRequest != null) {  // 取消授权
            palmAuthRequest.onCancel();
        }
        if (finish) LoginActivity.this.finish();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        cancelAndFinish(false);
    }

    @Override
    public void displayCaptchaCodeInput() {
        captchaInput.setVisibility(View.VISIBLE);
        codeEnable();
        loginEnable();
    }

    @Override
    public void showAcquireCodeDayLimit() {
        new PromptDialog.Builder(this, R.style.dialog_soft_input)
                .setTitle(getString(R.string.xn_frequent_operation))
                .setMessage(getString(R.string.xn_limit_day))
                .setPositiveButton(getString(R.string.xn_confirm), null)
                .show();
    }

    @Override
    public void showAcquireCodeMonthLimit() {
        new PromptDialog.Builder(this, R.style.dialog_soft_input)
                .setTitle(getString(R.string.xn_frequent_operation))
                .setMessage(getString(R.string.xn_limit_month))
                .setPositiveButton(getString(R.string.xn_confirm), null)
                .show();
    }

    @Override
    public void showCodeError() {
        if (loginByCodeError != null && presenter.isLoginByCode()) {
            loginByCodeError.setVisibility(View.VISIBLE);
            loginByCodeError.setErrorText(getString(R.string.xn_code_error));
//            loginByCodeError.setTag(R.id.codeInput, getVerificationCode());
        }
        codeInput.setError(true);
        captchaInput.setError(false);
    }

    @Override
    public void byCodeShowCaptchaError() {
        if (loginByCodeError != null && presenter.isLoginByCode()) {
            loginByCodeError.setVisibility(View.VISIBLE);
            loginByCodeError.setErrorText(getString(R.string.xn_captcha_error));
//            loginByCodeError.setTag(R.id.captchaInput, getImageCaptcha());
        }
        codeInput.setError(false);
        captchaInput.setError(true);
    }

    @Override
    public void byPwdShowCaptchaError() {

    }

    @Override
    public void showPwdError() {

    }

    @Override
    public boolean isImageCaptchaVisible() {
        return captchaInput.getVisibility() == View.VISIBLE;
    }

    @Override
    public void getPoliceSuccess(PolicyRes result, String tag) {
        if (presenter.TAG_USAGE.equals(tag)) {
            WebViewActivity.startActivity(this, R.string.xn_user_agreement, result.usageUrl);
        } else {
            WebViewActivity.startActivity(this, R.string.xn_privacy_policy, result.privacyUrl);
        }
    }

    @Override
    public void saveAccount(AccountRes account) {

    }

    @SuppressLint("StringFormatInvalid")
    @Override
    public void showFiveLimitError(boolean show, long millisUntilFinished) {
        if (show) {
            loginEnable();
        }
    }

    @SuppressLint("StringFormatInvalid")
    @Override
    public void showCaptchaLimitError(boolean show, long millisUntilFinished) {
        if (show) {
            if (presenter.isLoginByCode()) {
                if (presenter.isCodeNeedCaptcha()) {
                    if (loginByCodeError != null) {
                        loginByCodeError.setErrorText(getRS(R.string.xn_frequent_count, FormatUtil.millisToM(millisUntilFinished)));
                        loginByCodeError.setVisibility(View.VISIBLE);
                    }
                }
            }
        } else {
            if (loginByCodeError != null) {
                loginByCodeError.setErrorText("");
                loginByCodeError.setVisibility(View.GONE);
            }
        }
        codeEnable();
    }

    @Override
    public void showFrozenError(long endTime) {
        FrozenDialog.show(this, endTime);
        showPwdError();
    }

    @Override
    public void showCodeHelpTips() {

    }

    @Override
    public void showPhoneCode() {
        accountInput.setCc(presenter.getCountryCodeWithPlus());
        fillLastLoginReq();
    }

    /**
     * 隐私条款/用户协议是否勾选
     */
    private boolean isAgreementCheck() {
        if (!agreementCheck.isChecked()) {
            warning(getString(R.string.xn_read_agreement));
            return false;
        }
        return true;
    }

    class LoginClick extends CustomClickListener {
        @Override
        public void onSingleClick(View v) {
            if (v.getId() == R.id.loginOrRegister) {
                if (presenter.isLoginByCode()) {
                    AthenaImpl.getInstance(
                            getContext()).
                            loginCl(accountInput.isPhone(accountInput.getText()) ? "Phone" : "Mail");
                }
                if (isAgreementCheck()) {
                    presenter.login();
                }
            }
        }

        @Override
        public void onFastClick(View v) {

        }
    }

    @Override
    public void onNewIntent(Intent intent) {

    }

    class LoginWatch implements TextWatcher {
        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {

        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {

        }

        @Override
        public void afterTextChanged(Editable s) {
            showError();
            codeEnable();
            loginEnable();
        }
    }

    private void showError() {
        if (presenter.isLoginByCode()) {
            if (loginByCodeError != null) {
                boolean showError = isError(R.id.captchaInput, getImageCaptcha(), loginByCodeError)
                        || isError(R.id.codeInput, getVerificationCode(), loginByCodeError)
                        || (presenter.isCodeNeedCaptcha() && presenter.isShowCaptchaLimit());
                loginByCodeError.setVisibility(showError ? View.VISIBLE : View.GONE);
            }
        }
    }

    private boolean isError(int key, String value, ErrorView errorView) {
        Object oError = errorView.getTag(key);
        return value.equals(oError);
    }

    private void codeEnable() {
        if (codeInput.isCounting() || presenter.isShowCaptchaLimit()) {
            codeInput.setGetCodeEnable(false);
        } else {
            boolean enable;
            if (getType() == GlobalConstant.ACCOUNT_PHONE){
                enable = FormatUtils.checkRealPhone(getAccount());
            }else {
                enable = FormatUtil.checkEmail(getAccount());
            }
            if (captchaInput.getVisibility() == View.VISIBLE){
                enable = getImageCaptcha().length() >= 4 && enable;
            } else {
                enable = enable && verifyInput.getState() == BehaviorVerifyInput.STATE_SUCCESS;
            }
            codeInput.setGetCodeEnable(enable);
        }
    }

    private void loginEnable() {
        boolean enable = true;
        if (presenter.isLoginByCode()) {
            if (getType() == GlobalConstant.ACCOUNT_PHONE){
                enable = FormatUtils.checkRealPhone(getAccount()) && getVerificationCode().length() >= 4;
            }else {
                enable = FormatUtil.checkEmail(getAccount()) && getVerificationCode().length() >= 4;
            }

            if (presenter.isCodeNeedCaptcha() && presenter.isShowCaptchaLimit()) {
                enable = false;
            }

        }
        if (captchaInput.getVisibility() == View.VISIBLE) {
            if (getImageCaptcha().length() < 4) {
                enable = false;
            }
        } else {
            if (verifyInput.getState() != BehaviorVerifyInput.STATE_SUCCESS) {
                enable = false;
            }
        }

//        enable &= !presenter.isShowLimit();
        if (loginOrRegister != null) {
            loginOrRegister.setEnabled(enable);
        }
    }

    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (isMainProcess){
            outState.putString("account", getAccount());
            outState.putString("verificationCode", getVerificationCode());
            presenter.saveState(outState);
            verifyInput.saveState(outState);
            captchaInput.saveState(outState);
            outState.putBoolean("isChecked", agreementCheck.isChecked());

            if (palmAuthRequest != null) {
                outState.putString(PalmsKeys.EXTRA_AUTH_REQUEST, palmAuthRequest.getAuthRequestId());
            }
        }
    }

    @Override
    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (isMainProcess){
            accountInput.setText(savedInstanceState.getString("account"));
            codeInput.setText(savedInstanceState.getString("verificationCode"));
            presenter.restoreState(savedInstanceState);
            verifyInput.restoreState(savedInstanceState);
            captchaInput.restoreState(savedInstanceState);
            agreementCheck.setChecked(savedInstanceState.getBoolean("isChecked"));

            showError();
            codeEnable();
            loginEnable();
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (!isKeyboardShowing()){
            if (scrollView != null) scrollView.clearFocus();
        }
        if (accountInput != null && accountInput.isShowEmailAssociation()){
            shouldShowEmailAssociation = true;
            accountInput.hideEmailAssociation();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (accountInput != null) {
            accountInput.setCanShowPopView(hasFocus);
        }
    }

    /**
     * 只支持电话号码注册/登录
     */
    private boolean isOnlyPhoneNum() {
        if (palmAuthRequest != null
                && palmAuthRequest.getAuthParam().isOnlyPhoneNum()) {
            return true;
        } else if (!XNApiManager.instance().isPalmIdApp()) {
            PalmAuthParam palmAuthParam
                    = PalmID.instance(this).getAuthParam();  // 非正常流程打开登录界面
            return palmAuthParam != null && palmAuthParam.isOnlyPhoneNum();
        }
        return false;
    }

}
