package com.transsion.xuanniao.account.tools;

import android.view.View;

/**
 * <View 视图工具类>
 *
 * @author ming.wang
 * @version [V8.0, 2021/6/17]
 * @since V8.0
 */
public final class ViewUtils {
    private static final String TAG = "ViewUtils";
    private ViewUtils() {
    }

    /**
     * 根据指定的 id 获得指定的视图
     *
     * @param view 父控件 View
     * @param id 资源 id
     * @param <T> View 泛型
     * @return 根据指定的 id 获得指定的视图
     */
    public static <T extends View> T findViewById(View view, int id) {
        if (view != null) {
            return (T) view.findViewById(id);
        }
        return null;
    }
}
