package com.transsion.palmsdk.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

import com.transsion.palmsdk.util.PalmUtil;

import org.json.JSONObject;


/**
 * 用户基本信息，palm id登录方式会返回，减少客户请求
 */
class PalmUserInfo implements Parcelable {

    public String nickName;
    public String userName;
    public String avatarUrl;

    public PalmUserInfo() {

    }

    public PalmUserInfo(String jsonData) {
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            nickName = jsonObject.optString("nickName");
            userName = jsonObject.optString("userName");
            avatarUrl = jsonObject.optString("avatarUrl");
        } catch (Exception e) {
            PalmUtil.LOG.e(Log.getStackTraceString(e));
        }
    }

//    /**
//     * 返回json格式数据
//     */
//    public String toJson() {
//        try {
//            return new JSONObject().put("nickName", nickName)
//                    .put("userName", userName)
//                    .put("avatarUrl", avatarUrl).toString();
//        } catch (Exception e) {
//            PalmUtil.LOG.e(Log.getStackTraceString(e));
//        }
//        return null;
//    }

    protected PalmUserInfo(Parcel in) {
        nickName = in.readString();
        userName = in.readString();
        avatarUrl = in.readString();
    }

    public static final Creator<PalmUserInfo> CREATOR = new Creator<PalmUserInfo>() {
        @Override
        public PalmUserInfo createFromParcel(Parcel in) {
            return new PalmUserInfo(in);
        }

        @Override
        public PalmUserInfo[] newArray(int size) {
            return new PalmUserInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(nickName);
        dest.writeString(userName);
        dest.writeString(avatarUrl);
    }
}
