package com.transsion.palmsdk.util;


import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ThreadExecutors implements Executor {
    private static volatile ThreadExecutors sThreadExecutors;
    private final ExecutorService mExecutorService = Executors.newCachedThreadPool();

    private ThreadExecutors() {

    }

    public static ThreadExecutors getInstance() {
        if (sThreadExecutors == null) {
            synchronized (ThreadExecutors.class) {
                if (sThreadExecutors == null) {
                    sThreadExecutors = new ThreadExecutors();
                }
            }
        }
        return sThreadExecutors;
    }

    public void execute(Runnable runnable) {
        this.mExecutorService.execute(runnable);
    }
}