/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.transsion.palmsdk.Scope;
import com.transsion.palmsdk.util.PalmUtil;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PalmAuthParam
implements Parcelable {
    private String mAppid;
    private String mScopes;
    private String mRedirectUri;
    private String mState;
    private boolean mReqToken;
    private boolean mIgnorePalmApp;
    private boolean mShowTPLogin;
    private int mServerMode;
    private String mTudcSpName;
    private boolean mOnlyPhoneNum;
    private boolean mShowPrevLogin;
    private String mIntentActivity;
    private String mAppProcess;
    private boolean mBindTransID;
    private String mPkgName;
    private String mAppSign;
    public static final Parcelable.Creator<PalmAuthParam> CREATOR = new Parcelable.Creator<PalmAuthParam>(){

        public PalmAuthParam createFromParcel(Parcel in) {
            return new PalmAuthParam(in);
        }

        public PalmAuthParam[] newArray(int size) {
            return new PalmAuthParam[size];
        }
    };

    private PalmAuthParam() {
    }

    private PalmAuthParam(Builder builder) {
        if (builder == null) {
            return;
        }
        this.mAppid = builder.appid;
        if (builder.scopes == null || builder.scopes.length == 0) {
            this.mScopes = Scope.INFO_BASIC;
        } else {
            StringBuilder sBuilder = new StringBuilder();
            for (String scope : builder.scopes) {
                if (sBuilder.length() == 0) {
                    sBuilder.append(scope);
                    continue;
                }
                sBuilder.append(" ").append(scope);
            }
            if (sBuilder.indexOf(Scope.INFO_BASIC) < 0) {
                sBuilder.insert(0, Scope.INFO_BASIC + " ");
            }
            this.mScopes = sBuilder.toString();
        }
        this.mRedirectUri = TextUtils.isEmpty((CharSequence)builder.redirectUri) ? "https://account.palm.tech/client/callback" : builder.redirectUri;
        this.mState = PalmUtil.randomString(8);
        this.mReqToken = builder.reqToken;
        this.mIgnorePalmApp = builder.ignorePalmApp;
        this.mShowTPLogin = builder.showTPLogin;
        this.mServerMode = builder.serverMode;
        this.mTudcSpName = builder.tudcSpName;
        this.mOnlyPhoneNum = builder.onlyPhoneNum;
        this.mShowPrevLogin = builder.showPrevLogin;
        this.mIntentActivity = builder.intentActivity;
        this.mAppProcess = builder.appProcess;
        this.mBindTransID = builder.bindTransID;
    }

    protected PalmAuthParam copy() {
        PalmAuthParam authParam = new PalmAuthParam();
        authParam.mAppid = this.mAppid;
        authParam.mScopes = this.mScopes;
        authParam.mState = this.mState;
        authParam.mAppSign = this.mAppSign;
        authParam.mPkgName = this.mPkgName;
        authParam.mReqToken = true;
        authParam.mShowTPLogin = this.mShowTPLogin;
        authParam.mRedirectUri = "https://account.palm.tech/client/callback";
        authParam.mOnlyPhoneNum = this.mOnlyPhoneNum;
        authParam.mShowPrevLogin = this.mShowPrevLogin;
        authParam.mIntentActivity = this.mIntentActivity;
        authParam.mBindTransID = this.mBindTransID;
        return authParam;
    }

    protected PalmAuthParam(Parcel in) {
        this.mAppid = in.readString();
        this.mScopes = in.readString();
        this.mRedirectUri = in.readString();
        this.mState = in.readString();
        this.mReqToken = in.readInt() == 1;
        this.mShowTPLogin = in.readInt() == 1;
        this.mPkgName = in.readString();
        this.mAppSign = in.readString();
        try {
            String option = in.readString();
            PalmUtil.LOG.d((Object)("option = " + option));
            JSONObject optionJs = new JSONObject(option);
            this.mOnlyPhoneNum = optionJs.optBoolean("onlyPhoneNum", false);
            this.mShowPrevLogin = optionJs.optBoolean("showPrevLogin", true);
            this.mIntentActivity = optionJs.optString("intentActivity", "");
        }
        catch (Exception e) {
            this.mShowPrevLogin = true;
        }
    }

    public String getAppid() {
        return this.mAppid;
    }

    public String getScopes() {
        return this.mScopes;
    }

    public String getState() {
        return this.mState;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public boolean isReqToken() {
        return this.mReqToken && TextUtils.equals((CharSequence)this.mRedirectUri, (CharSequence)"https://account.palm.tech/client/callback");
    }

    public boolean ignorePalmApp() {
        return this.mIgnorePalmApp;
    }

    public void setIgnorePalmApp(boolean ignore) {
        this.mIgnorePalmApp = ignore;
    }

    public boolean isShowTPLogin() {
        return this.mShowTPLogin;
    }

    public int getServerMode() {
        return this.mServerMode;
    }

    public boolean hasTudc() {
        return this.mTudcSpName != null;
    }

    public String getTudcSpName() {
        return this.mTudcSpName;
    }

    public boolean isOnlyPhoneNum() {
        return this.mOnlyPhoneNum;
    }

    public boolean isShowPrevLogin() {
        return this.mShowPrevLogin;
    }

    public String getIntentActivity() {
        return this.mIntentActivity;
    }

    public String getAppProcess() {
        return this.mAppProcess;
    }

    public boolean isBindTransID() {
        return this.mBindTransID;
    }

    protected void setupApp(Context context) {
        this.mPkgName = context.getPackageName();
        this.mAppSign = PalmUtil.getAppSign(context, "MD5");
    }

    public String getPkgName() {
        return this.mPkgName;
    }

    public String getAppSign() {
        return this.mAppSign;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mAppid);
        dest.writeString(this.mScopes);
        dest.writeString(this.mRedirectUri);
        dest.writeString(this.mState);
        dest.writeInt(this.mReqToken ? 1 : 0);
        dest.writeInt(this.mShowTPLogin ? 1 : 0);
        dest.writeString(this.mPkgName);
        dest.writeString(this.mAppSign);
        try {
            dest.writeString(new JSONObject().put("onlyPhoneNum", this.mOnlyPhoneNum).put("showPrevLogin", this.mShowPrevLogin).put("intentActivity", (Object)this.mIntentActivity).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("client_id", this.mAppid);
        map.put("redirect_uri", this.mRedirectUri);
        map.put("scope", this.mScopes);
        map.put("state", this.mState);
        return map;
    }

    public String toString() {
        return this.mAppid + "," + this.mScopes + "," + this.mRedirectUri;
    }

    public static class Builder {
        private String appid;
        private String[] scopes;
        private String redirectUri;
        private boolean reqToken = false;
        private boolean ignorePalmApp = false;
        private boolean showTPLogin = true;
        private int serverMode = 4;
        private String tudcSpName = null;
        private boolean onlyPhoneNum = false;
        private boolean showPrevLogin = true;
        private String intentActivity = null;
        private String appProcess = null;
        private boolean bindTransID = true;

        public Builder setAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public Builder setScopes(String[] scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder ignorePalmApp(boolean ignorePalmApp) {
            this.ignorePalmApp = ignorePalmApp;
            return this;
        }

        public Builder supportTPLogin(boolean showTPLogin) {
            this.showTPLogin = showTPLogin;
            return this;
        }

        public Builder requestToken() {
            this.reqToken = true;
            return this;
        }

        public Builder setServerMode(int serverMode) {
            this.serverMode = serverMode;
            return this;
        }

        public Builder hasTudc(String spName) {
            this.tudcSpName = spName;
            return this;
        }

        public Builder onlyPhoneNum(boolean onlyPhoneNum) {
            this.onlyPhoneNum = onlyPhoneNum;
            return this;
        }

        public Builder showPrevLogin(boolean showPrevLogin) {
            this.showPrevLogin = showPrevLogin;
            return this;
        }

        public Builder intentActivity(Class<?> intentActivity) {
            if (intentActivity != null) {
                this.intentActivity = intentActivity.getName();
            }
            return this;
        }

        public Builder setAppProcess(String appProcess) {
            this.appProcess = appProcess;
            return this;
        }

        public Builder bindTransID(boolean bindTransID) {
            this.bindTransID = bindTransID;
            return this;
        }

        public PalmAuthParam build() {
            return new PalmAuthParam(this);
        }
    }
}

