/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athenacust.AthenaCust;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.gslb.GslbSdk;
import com.transsion.palmsdk.PalmAuthParam;
import com.transsion.palmsdk.PalmConstants;
import com.transsion.palmsdk.PalmID;
import com.transsion.palmsdk.account.XNManager;
import com.transsion.palmsdk.auth.IPalmAuthResponse;
import com.transsion.palmsdk.auth.PalmAuthManager;
import com.transsion.palmsdk.auth.PalmAuthSession;
import com.transsion.palmsdk.data.PalmAuthRequest;
import com.transsion.palmsdk.data.PalmAuthResult;
import com.transsion.palmsdk.data.PalmTokenInfo;
import com.transsion.palmsdk.http.PalmHttpCallback;
import com.transsion.palmsdk.http.PalmHttpClient;
import com.transsion.palmsdk.tudc.TudcAccount;
import com.transsion.palmsdk.util.PalmUtil;
import com.transsion.palmsdk.util.ThreadExecutors;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class PalmDefaultImpl
extends PalmID {
    private final Context mContext;
    private final PalmAuthParam mPalmAuthParam;
    private boolean isMainProcess = true;
    private boolean isFullSDK = false;

    PalmDefaultImpl(Context context, PalmAuthParam palmAuthParam) {
        this.mContext = context.getApplicationContext();
        this.mPalmAuthParam = palmAuthParam;
        this.mPalmAuthParam.setupApp(context);
        this.initSDK(this.mContext);
    }

    private void initSDK(Context context) {
        AthenaAnalytics.init((Context)context, (String)"", (int)7710, (boolean)false);
        Bundle eparam = new Bundle();
        eparam.putString("appid", this.mPalmAuthParam.getAppid());
        eparam.putString("version", "1.2.0.13_06");
        new AthenaCust("sdk_init", 7710).trackCommon(eparam, null).submit();
        GslbSdk.init((Context)context, (String[])new String[]{"account.palm.tech", "auth-account.palm.tech", "api-cloud.palm.tech"}, null);
        String appProcess = this.mPalmAuthParam.getAppProcess();
        this.isMainProcess = TextUtils.isEmpty((CharSequence)appProcess) ? true : TextUtils.equals((CharSequence)appProcess, (CharSequence)PalmUtil.getCurProcessName(this.mContext));
        try {
            if (this.isMainProcess) {
                Class.forName("com.transsion.xuanniao.account.api.PalmInitialize");
            }
            Class.forName("com.transsion.xuanniao.account.login.view.LoginActivity");
            this.isFullSDK = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isMainProcess) {
            ThreadExecutors.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    PalmConstants.SERVER_MODE = PalmDefaultImpl.this.mPalmAuthParam.getServerMode();
                    PalmDefaultImpl.this.initCloudConfig();
                    if (PalmDefaultImpl.this.isFullSDK) {
                        XNManager.getInstance().applyKey(PalmDefaultImpl.this.mContext, PalmDefaultImpl.this.mPalmAuthParam.getAppid(), PalmDefaultImpl.this.mPalmAuthParam.getServerMode());
                    }
                }
            });
        } else {
            PalmConstants.SERVER_MODE = this.mPalmAuthParam.getServerMode();
        }
        PalmUtil.LOG.d((Object)("initSDK isFullSDK = " + this.isFullSDK + ", version = " + "1.2.0.13_06"));
    }

    private void initCloudConfig() {
        try {
            UserManager um;
            Context safeContext = this.mContext;
            if (Build.VERSION.SDK_INT >= 24 && !(um = (UserManager)this.mContext.getSystemService("user")).isUserUnlocked()) {
                safeContext = this.mContext.createDeviceProtectedStorageContext();
            }
            SharedPreferences palmPrefs = safeContext.getSharedPreferences("palm_config", 0);
            String palmAppConfig = palmPrefs.getString("palm_app_array", null);
            long palmUpdateTime = palmPrefs.getLong("palm_update_time", 0L);
            if ((palmAppConfig == null || Math.abs(System.currentTimeMillis() - palmUpdateTime) > 86400000L) && PalmUtil.isNetworkAvailable(this.mContext)) {
                Map<String, Object> formData = PalmUtil.genConfigParam(this.mContext);
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Client-ID", "palmid");
                String response = PalmHttpClient.getInstance().getPalmAppConfig(header, formData);
                if (response != null) {
                    try {
                        JSONObject jsonObject = new JSONObject(response);
                        JSONArray jsonArray = jsonObject.getJSONArray("cloudClientConfigs");
                        SharedPreferences.Editor editor = palmPrefs.edit().putString("cloudClientConfigs", response);
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            JSONObject configJson = jsonArray.getJSONObject(i);
                            if (configJson.getInt("type") != 17) continue;
                            editor.putString("palm_app_array", configJson.getJSONObject("configMap").toString()).putLong("palm_update_time", System.currentTimeMillis());
                            break;
                        }
                        editor.apply();
                    }
                    catch (Exception e) {
                        PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void authorize(Context context, final PalmID.IPalmAuthListener authListener) {
        final Bundle eparam = new Bundle();
        eparam.putString("appid", this.mPalmAuthParam.getAppid());
        eparam.putString("version", "1.2.0.13_06");
        new AthenaCust("sdk_start_auth", 7710).trackCommon(eparam, null).submit();
        final PalmID.IPalmAuthListener wrapAuthListener = new PalmID.IPalmAuthListener(){

            private void startIntentActivity(String intentActivity, Bundle extras) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW").setClassName(PalmDefaultImpl.this.mContext, intentActivity).addFlags(0x10000000).putExtras(extras);
                    PalmDefaultImpl.this.mContext.startActivity(intent);
                }
                catch (Exception e) {
                    PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
            }

            @Override
            public void onSuccess(PalmAuthResult result) {
                PalmUtil.LOG.d((Object)"onSuccess");
                String intentActivity = PalmDefaultImpl.this.mPalmAuthParam.getIntentActivity();
                if (!TextUtils.isEmpty((CharSequence)intentActivity)) {
                    String tokenInfo = "";
                    String userInfo = "";
                    try {
                        tokenInfo = new JSONObject().put("access_token", (Object)result.getAccessToken()).put("refresh_token", (Object)result.getRefreshToken()).put("open_id", (Object)result.getOpenid()).toString();
                        if (result.getNickName() != null || result.getUserName() != null) {
                            userInfo = new JSONObject().put("nickName", (Object)result.getNickName()).put("userName", (Object)result.getUserName()).put("avatarUrl", (Object)result.getAvatarUrl()).toString();
                        }
                    }
                    catch (Exception e) {
                        PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                    }
                    Bundle bundle = new Bundle();
                    bundle.putString("token_info", tokenInfo);
                    bundle.putString("user_info", userInfo);
                    this.startIntentActivity(intentActivity, bundle);
                } else if (authListener != null) {
                    authListener.onSuccess(result);
                }
            }

            @Override
            public void onCancel() {
                PalmUtil.LOG.d((Object)"onCancel");
                if (authListener != null) {
                    authListener.onCancel();
                }
            }

            @Override
            public void onFailure(int errorCode, String errorMessage) {
                PalmUtil.LOG.d((Object)("onFailure errorCode = " + errorCode + ", errorMessage = " + errorMessage));
                if (authListener != null) {
                    authListener.onFailure(errorCode, errorMessage);
                }
            }
        };
        if (!PalmUtil.isNetworkAvailable(this.mContext)) {
            wrapAuthListener.onFailure(40103, "network unavailable");
            eparam.putString("result", "failure");
            eparam.putInt("errcode", 40103);
            new AthenaCust("sdk_start_auth_callback", 7710).trackCommon(eparam, null).submit();
            return;
        }
        if (this.isMainProcess) {
            XNManager.getInstance().applyKey(this.mContext, this.mPalmAuthParam.getAppid(), this.mPalmAuthParam.getServerMode());
        }
        ThreadExecutors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                final Bundle aTempResult = new Bundle();
                final PalmAuthRequest palmAuthRequest = new PalmAuthRequest(PalmDefaultImpl.this.mPalmAuthParam, PalmDefaultImpl.this.isFullSDK, new IPalmAuthResponse.Stub(){

                    @Override
                    public void onCancel() throws RemoteException {
                        wrapAuthListener.onCancel();
                        eparam.putString("result", "cancel");
                        new AthenaCust("sdk_start_auth_callback", 7710).trackCommon(eparam, null).submit();
                    }

                    @Override
                    public void setResult(Bundle result) throws RemoteException {
                        if (aTempResult.size() > 0) {
                            result.putAll(aTempResult);
                            aTempResult.clear();
                        }
                        if (result.containsKey("token_info")) {
                            wrapAuthListener.onSuccess(new PalmAuthResult(result));
                            eparam.putString("result", "success");
                            new AthenaCust("sdk_start_auth_callback", 7710).trackCommon(eparam, null).submit();
                        } else {
                            int errorCode = result.getInt("error_code", 0);
                            String errorMessage = result.getString("error_message");
                            wrapAuthListener.onFailure(errorCode, errorMessage);
                            eparam.putString("result", "failure");
                            eparam.putInt("errcode", errorCode);
                            new AthenaCust("sdk_start_auth_callback", 7710).trackCommon(eparam, null).submit();
                        }
                    }
                });
                if (PalmDefaultImpl.this.mPalmAuthParam.hasTudc()) {
                    TudcAccount.getInstance(PalmDefaultImpl.this.mPalmAuthParam.getTudcSpName()).clear(PalmDefaultImpl.this.mContext);
                }
                Intent palmIntent = PalmDefaultImpl.this.mPalmAuthParam.ignorePalmApp() ? null : PalmUtil.queryPalmAppIntent(PalmDefaultImpl.this.mContext, false);
                PalmUtil.LOG.d((Object)("palm id intent = " + palmIntent));
                if (palmIntent != null) {
                    Cursor cursor = null;
                    if ("tech.palm.id".equals(palmIntent.getPackage())) {
                        cursor = PalmDefaultImpl.this.mContext.getContentResolver().query(Uri.parse((String)"content://com.palm.id.account.AccountProvider/logged"), null, null, null, null);
                    } else if ("com.rlk.mi".equals(palmIntent.getPackage())) {
                        cursor = PalmDefaultImpl.this.mContext.getContentResolver().query(Uri.parse((String)"content://com.palm.id.old.account.AccountProvider/logged"), null, null, null, null);
                    }
                    boolean isPalmLogged = false;
                    if (cursor != null) {
                        isPalmLogged = cursor.getCount() > 0;
                        cursor.close();
                    }
                    if (isPalmLogged) {
                        Bundle param = new Bundle();
                        if (PalmDefaultImpl.this.isFullSDK) {
                            param.putParcelable("auth_param", (Parcelable)PalmDefaultImpl.this.mPalmAuthParam.copy());
                        } else {
                            param.putParcelable("auth_param", (Parcelable)PalmDefaultImpl.this.mPalmAuthParam);
                        }
                        param.putBoolean("host_mode", palmIntent.getBooleanExtra("host_mode", false));
                        PalmID.IPalmAuthListener sdkAuthListener = new PalmID.IPalmAuthListener(){

                            @Override
                            public void onSuccess(PalmAuthResult result) {
                                if (PalmDefaultImpl.this.isFullSDK && (result.getNickName() != null || result.getUserName() != null)) {
                                    try {
                                        aTempResult.putString("user_info", new JSONObject().put("nickName", (Object)result.getNickName()).put("userName", (Object)result.getUserName()).put("avatarUrl", (Object)result.getAvatarUrl()).toString());
                                    }
                                    catch (Exception e) {
                                        PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                                    }
                                }
                                wrapAuthListener.onSuccess(result);
                            }

                            @Override
                            public void onCancel() {
                                wrapAuthListener.onCancel();
                            }

                            @Override
                            public void onFailure(int errorCode, String errorMessage) {
                                if (errorCode == 49999) {
                                    if (PalmDefaultImpl.this.isFullSDK && PalmDefaultImpl.this.isMainProcess) {
                                        PalmAuthManager.getInstance(PalmDefaultImpl.this.mContext).handleAuthRequest(palmAuthRequest);
                                    }
                                } else {
                                    wrapAuthListener.onFailure(errorCode, errorMessage);
                                }
                            }
                        };
                        for (int retryCount = 0; retryCount < 2; ++retryCount) {
                            if (!new PalmAuthSession(PalmDefaultImpl.this.mContext, palmIntent, param, sdkAuthListener, PalmDefaultImpl.this.isMainProcess).create()) continue;
                            return;
                        }
                    }
                }
                if (PalmDefaultImpl.this.isFullSDK && PalmDefaultImpl.this.isMainProcess) {
                    PalmAuthManager.getInstance(PalmDefaultImpl.this.mContext).handleAuthRequest(palmAuthRequest);
                }
            }
        });
    }

    @Override
    public void logout(String accessToken, String refreshToken, final PalmID.IPalmApiListener<Boolean> apiListener) {
        Bundle eparam = new Bundle();
        eparam.putString("appid", this.mPalmAuthParam.getAppid());
        eparam.putString("version", "1.2.0.13_06");
        new AthenaCust("sdk_logout", 7710).trackCommon(eparam, null).submit();
        if (!this.isMainProcess) {
            if (apiListener != null) {
                apiListener.onFailure(40106, "not main process");
            }
            return;
        }
        if (!PalmUtil.isNetworkAvailable(this.mContext)) {
            if (apiListener != null) {
                apiListener.onFailure(40103, "network unavailable");
            }
            return;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + accessToken);
        header.put("Client-ID", this.mPalmAuthParam.getAppid());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("refresh-token", refreshToken);
        PalmHttpClient.getInstance().expireToken(header, params, new PalmHttpCallback<String>(){

            @Override
            public void onSuccess(String response) {
                if (apiListener != null) {
                    apiListener.onSuccess(true);
                }
            }

            @Override
            public void onFailure(int errorCode, String errorMessage) {
                if (apiListener != null) {
                    apiListener.onFailure(errorCode, errorMessage);
                }
            }
        });
    }

    @Override
    public void callOpenApi(String path, String accessToken, Map<String, Object> formData, final PalmID.IPalmApiListener<String> apiListener) {
        final Bundle eparam = new Bundle();
        eparam.putString("appid", this.mPalmAuthParam.getAppid());
        eparam.putString("version", "1.2.0.13_06");
        eparam.putString("param", path);
        new AthenaCust("sdk_openapi", 7710).trackCommon(eparam, null).submit();
        if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)accessToken)) {
            if (apiListener != null) {
                apiListener.onFailure(40101, "invalid arguments");
            }
            eparam.putString("result", "failure");
            eparam.putInt("errcode", 40101);
            new AthenaCust("sdk_openapi_callback", 7710).trackCommon(eparam, null).submit();
            return;
        }
        if (!PalmUtil.isNetworkAvailable(this.mContext)) {
            if (apiListener != null) {
                apiListener.onFailure(40103, "network unavailable");
            }
            eparam.putString("result", "failure");
            eparam.putInt("errcode", 40103);
            new AthenaCust("sdk_openapi_callback", 7710).trackCommon(eparam, null).submit();
            return;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + accessToken);
        header.put("Client-ID", this.mPalmAuthParam.getAppid());
        PalmHttpClient.getInstance().callOpenApi(path, header, formData, new PalmHttpCallback<String>(){

            @Override
            public void onSuccess(String response) {
                if (apiListener != null) {
                    apiListener.onSuccess(response);
                }
                eparam.putString("result", "success");
                new AthenaCust("sdk_openapi_callback", 7710).trackCommon(eparam, null).submit();
            }

            @Override
            public void onFailure(int errorCode, String errorMessage) {
                if (apiListener != null) {
                    apiListener.onFailure(errorCode, errorMessage);
                }
                eparam.putString("result", "failure");
                eparam.putInt("errcode", errorCode);
                new AthenaCust("sdk_openapi_callback", 7710).trackCommon(eparam, null).submit();
            }
        });
    }

    @Override
    public void refreshToken(String refreshToken, final PalmID.IPalmApiListener<PalmTokenInfo> apiListener) {
        final String appid = this.mPalmAuthParam.getAppid();
        Bundle eparam = new Bundle();
        eparam.putString("appid", appid);
        eparam.putString("version", "1.2.0.13_06");
        new AthenaCust("sdk_refresh_token", 7710).trackCommon(eparam, null).submit();
        if (TextUtils.isEmpty((CharSequence)refreshToken)) {
            if (apiListener != null) {
                apiListener.onFailure(40101, "invalid arguments");
            }
            eparam.putString("result", "failure");
            eparam.putInt("errcode", 40101);
            new AthenaCust("sdk_refresh_token_callback", 7710).trackCommon(eparam, null).submit();
            return;
        }
        if (!PalmUtil.isNetworkAvailable(this.mContext)) {
            if (apiListener != null) {
                apiListener.onFailure(40103, "network unavailable");
            }
            eparam.putString("result", "failure");
            eparam.putInt("errcode", 40103);
            new AthenaCust("sdk_refresh_token_callback", 7710).trackCommon(eparam, null).submit();
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("refresh_token", refreshToken);
        params.put("grant_type", "refresh_token");
        params.put("client_id", appid);
        params.put("scope", this.mPalmAuthParam.getScopes());
        PalmHttpClient.getInstance().refreshToken(params, new PalmHttpCallback<PalmTokenInfo>(){

            @Override
            public void onSuccess(PalmTokenInfo palmTokenInfo) {
                PalmUtil.LOG.e((Object)"refreshToken success");
                if (apiListener != null) {
                    apiListener.onSuccess(palmTokenInfo);
                    Bundle eparam = new Bundle();
                    eparam.putString("appid", appid);
                    eparam.putString("version", "1.2.0.13_06");
                    eparam.putString("result", "success");
                    new AthenaCust("sdk_refresh_token_callback", 7710).trackCommon(eparam, null).submit();
                }
            }

            @Override
            public void onFailure(int errorCode, String errorMessage) {
                PalmUtil.LOG.e((Object)("refreshToken errorCode = " + errorCode + " errorMessage = " + errorMessage));
                if (apiListener != null) {
                    apiListener.onFailure(errorCode, errorMessage);
                    Bundle eparam = new Bundle();
                    eparam.putString("appid", appid);
                    eparam.putString("version", "1.2.0.13_06");
                    eparam.putString("result", "failure");
                    eparam.putInt("errcode", errorCode);
                    new AthenaCust("sdk_refresh_token_callback", 7710).trackCommon(eparam, null).submit();
                }
            }
        });
    }

    public PalmAuthParam getPalmAuthParam() {
        return this.mPalmAuthParam;
    }
}

