/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.transsion.palmsdk.PalmAuthParam;
import com.transsion.palmsdk.PalmDefaultImpl;
import com.transsion.palmsdk.PalmEmptyImpl;
import com.transsion.palmsdk.data.PalmAuthResult;
import com.transsion.palmsdk.data.PalmTokenInfo;
import com.transsion.palmsdk.util.PalmUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class PalmID {
    private static final HashMap<Context, PalmID> sInstanceMap = new HashMap(4);
    private static Context sAppContext;
    public static final int SERVER_DEV = 1;
    public static final int SERVER_TEST = 2;
    public static final int SERVER_PRE = 3;
    public static final int SERVER_ONLINE = 4;

    public static Context getContext() {
        return sAppContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PalmID createInstance(Context context, PalmAuthParam palmAuthParam) {
        if (context == null || palmAuthParam == null) {
            throw new IllegalArgumentException("invalid arguments");
        }
        if (sAppContext == null) {
            sAppContext = context.getApplicationContext();
        }
        Class<PalmID> clazz = PalmID.class;
        synchronized (PalmID.class) {
            PalmID palmID;
            Context appContext = context.getApplicationContext();
            if (!sInstanceMap.containsKey(appContext)) {
                palmID = new PalmDefaultImpl(context, palmAuthParam);
                sInstanceMap.put(appContext, palmID);
            } else {
                palmID = sInstanceMap.get(appContext);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return palmID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PalmID instance(Context context) {
        if (context == null) {
            return new PalmEmptyImpl();
        }
        Class<PalmID> clazz = PalmID.class;
        synchronized (PalmID.class) {
            Context appContext = context.getApplicationContext();
            PalmID palmID = sInstanceMap.get(appContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return palmID != null ? palmID : new PalmEmptyImpl();
        }
    }

    public PalmAuthParam getAuthParam() {
        if (this instanceof PalmDefaultImpl) {
            return ((PalmDefaultImpl)this).getPalmAuthParam();
        }
        return null;
    }

    public static void parseIntent(Intent intent, IPalmAuthListener authListener) {
        if (intent == null || authListener == null) {
            PalmUtil.LOG.e((Object)"invalid arguments");
            return;
        }
        Bundle result = intent.getExtras();
        if (result.containsKey("token_info")) {
            authListener.onSuccess(new PalmAuthResult(result));
        } else {
            int errorCode = result.getInt("error_code", 0);
            String errorMessage = result.getString("error_message");
            if (errorCode == 30000) {
                authListener.onCancel();
            } else {
                authListener.onFailure(errorCode, errorMessage);
            }
        }
    }

    public abstract void authorize(Context var1, IPalmAuthListener var2);

    public abstract void callOpenApi(String var1, String var2, Map<String, Object> var3, IPalmApiListener<String> var4);

    public abstract void refreshToken(String var1, IPalmApiListener<PalmTokenInfo> var2);

    public abstract void logout(String var1, String var2, IPalmApiListener<Boolean> var3);

    public static interface IPalmAuthListener {
        public void onSuccess(PalmAuthResult var1);

        public void onCancel();

        public void onFailure(int var1, String var2);
    }

    public static interface IPalmApiListener<T> {
        public void onSuccess(T var1);

        public void onFailure(int var1, String var2);
    }

    public static interface IPalmStatusListener {
        public void onSignIn(int var1, String var2);

        public void onSignOut(int var1);
    }
}

