/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.account;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.transsion.palmsdk.account.LiteTeeManager;
import com.transsion.palmsdk.account.XNManager;
import com.transsion.palmsdk.util.PalmUtil;

public class PalmAccProvider
extends ContentProvider {
    public static String AUTHORITY;
    private static final UriMatcher MATCHER;
    private static final int CODE_STATUS = 1;
    private static final int CODE_TOKEN = 2;
    private static final int CODE_PROFILE = 3;
    private static final int CODE_LINKED = 4;

    public boolean onCreate() {
        AUTHORITY = this.getContext().getPackageName() + ".PalmAccProvider";
        MATCHER.addURI(AUTHORITY, "status", 1);
        MATCHER.addURI(AUTHORITY, "token", 2);
        MATCHER.addURI(AUTHORITY, "profile", 3);
        MATCHER.addURI(AUTHORITY, "linked", 4);
        return true;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        Context context = this.getContext();
        MatrixCursor cursor = null;
        PalmUtil.LOG.d((Object)("query uri = " + uri));
        switch (MATCHER.match(uri)) {
            case 1: {
                int status = XNManager.getInstance().isLogged(context) ? 1 : 0;
                cursor = new MatrixCursor(new String[]{"status"}, 1);
                cursor.addRow(new Object[]{status});
                return cursor;
            }
            case 2: {
                String token = XNManager.getInstance().getToken();
                cursor = new MatrixCursor(new String[]{"token"}, 1);
                cursor.addRow(new Object[]{token});
                return cursor;
            }
            case 3: {
                String profile = XNManager.getInstance().getAccountInfo(context);
                cursor = new MatrixCursor(new String[]{"profile"}, 1);
                cursor.addRow(new Object[]{profile});
                return cursor;
            }
        }
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        if (values == null) {
            return null;
        }
        try {
            switch (MATCHER.match(uri)) {
                case 2: {
                    String aToken = values.getAsString("aToken");
                    String rToken = values.getAsString("rToken");
                    if (TextUtils.isEmpty((CharSequence)aToken) || TextUtils.isEmpty((CharSequence)rToken)) break;
                    XNManager.getInstance().setToken(this.getContext(), aToken, rToken);
                    PalmUtil.LOG.d((Object)"setToken success");
                    break;
                }
                case 4: {
                    String linkedPkg = values.getAsString("linkedPkg");
                    String linkedId = values.getAsString("linkedId");
                    String linkedBd = values.getAsString("linkedBd");
                    if (TextUtils.isEmpty((CharSequence)linkedPkg) || TextUtils.isEmpty((CharSequence)linkedId)) break;
                    LiteTeeManager.instance(this.getContext()).saveString("linked_pkg", linkedPkg);
                    LiteTeeManager.instance(this.getContext()).saveString("linked_id", linkedId);
                    if (linkedBd != null) {
                        LiteTeeManager.instance(this.getContext()).saveString("linked_bd", linkedBd);
                    }
                    PalmUtil.LOG.d((Object)"setLinked success");
                }
            }
        }
        catch (Exception e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public static String getAuthority(Context context) {
        return context.getPackageName() + ".PalmAccProvider";
    }

    static {
        MATCHER = new UriMatcher(-1);
    }
}

