/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.account;

import android.app.Activity;
import android.content.Context;
import com.transsion.palmsdk.PalmID;

public class XNManager {
    private AccountProvider accountProvider;

    private XNManager() {
    }

    public static XNManager getInstance() {
        return XNManagerInner.instance;
    }

    public void setAccountProvider(AccountProvider provider) {
        this.accountProvider = provider;
    }

    public void applyKey(Context context, String clientId, int serverMode) {
        if (this.accountProvider != null) {
            this.accountProvider.applyKey(context, clientId, serverMode);
        }
    }

    public boolean isLogged(Context context) {
        if (this.accountProvider != null) {
            return this.accountProvider.isLogged(context);
        }
        return false;
    }

    public boolean refreshToken(Context context, String tudcToken, PalmID.IPalmApiListener<String> apiListener) {
        if (this.accountProvider != null) {
            return this.accountProvider.refreshToken(context, tudcToken, apiListener);
        }
        return false;
    }

    public void setToken(Context context, String aToken, String rToken) {
        if (this.accountProvider != null) {
            this.accountProvider.setToken(context, aToken, rToken);
        }
    }

    public String getToken() {
        if (this.accountProvider != null) {
            return this.accountProvider.getToken();
        }
        return null;
    }

    public long getTokenExpiredTs(Context context) {
        if (this.accountProvider != null) {
            return this.accountProvider.getTokenExpiredTs(context);
        }
        return 0L;
    }

    public void getLoginRecord(Context context, int type, PalmID.IPalmApiListener<String> apiListener) {
        if (this.accountProvider != null) {
            this.accountProvider.getLoginRecord(context, type, apiListener);
        }
    }

    public String getAccountInfo(Context context) {
        if (this.accountProvider != null) {
            return this.accountProvider.getAccountInfo(context);
        }
        return null;
    }

    public void silentLogin(Context context, String requestId) {
        if (this.accountProvider != null) {
            this.accountProvider.silentLogin(context, requestId);
        }
    }

    public void silentLogout(Context context, boolean force) {
        if (this.accountProvider != null) {
            this.accountProvider.silentLogout(context, force);
        }
    }

    public void showBindPhoneDialog(Activity activity) {
        if (this.accountProvider != null) {
            this.accountProvider.showBindPhoneDialog(activity);
        }
    }

    static class XNManagerInner {
        static XNManager instance = new XNManager();

        XNManagerInner() {
        }
    }

    public static interface AccountProvider {
        public void applyKey(Context var1, String var2, int var3);

        public boolean isLogged(Context var1);

        public boolean refreshToken(Context var1, String var2, PalmID.IPalmApiListener<String> var3);

        public void setToken(Context var1, String var2, String var3);

        public String getToken();

        public long getTokenExpiredTs(Context var1);

        public void getLoginRecord(Context var1, int var2, PalmID.IPalmApiListener<String> var3);

        public String getAccountInfo(Context var1);

        public void silentLogin(Context var1, String var2);

        public void silentLogout(Context var1, boolean var2);

        public void showBindPhoneDialog(Activity var1);
    }
}

