/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.auth;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.palmsdk.account.XNManager;
import com.transsion.palmsdk.data.PalmAuthRequest;
import com.transsion.palmsdk.util.PalmUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class PalmAuthManager {
    private static volatile PalmAuthManager sPalmAuthManager;
    private final Context mContext;
    private final Map<String, PalmAuthRequest> mAuthRequestMap;

    private PalmAuthManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.mAuthRequestMap = new ConcurrentHashMap<String, PalmAuthRequest>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PalmAuthManager getInstance(Context context) {
        if (sPalmAuthManager != null) return sPalmAuthManager;
        Class<PalmAuthManager> clazz = PalmAuthManager.class;
        synchronized (PalmAuthManager.class) {
            if (sPalmAuthManager != null) return sPalmAuthManager;
            sPalmAuthManager = new PalmAuthManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sPalmAuthManager;
        }
    }

    public void handleAuthRequest(PalmAuthRequest authRequest) {
        this.addAuthRequest(authRequest);
        try {
            boolean isLogged = XNManager.getInstance().isLogged(this.mContext);
            PalmUtil.LOG.d((Object)("isLogged = " + isLogged + " isHostMode = " + authRequest.isHostMode()));
            if (isLogged) {
                if (authRequest.isSilentMode()) {
                    XNManager.getInstance().silentLogin(this.mContext, authRequest.getAuthRequestId());
                } else {
                    Intent intent = authRequest.showPrevLogin() ? new Intent("intent.action.PALM_ID_PREV") : new Intent("intent.action.PALM_ID_AUTH");
                    intent.setPackage(this.mContext.getPackageName());
                    intent.putExtra("auth_request", authRequest.getAuthRequestId());
                    if ("tech.palm.id".equals(this.mContext.getPackageName())) {
                        intent.addFlags(0x10008000);
                    } else {
                        intent.addFlags(0x10000000);
                    }
                    this.mContext.startActivity(intent);
                }
            } else if (authRequest.isSilentMode() || authRequest.isHostMode()) {
                authRequest.setException(40105, "palm id not login");
            } else {
                Intent intent = new Intent();
                intent.setClassName(this.mContext.getPackageName(), "com.transsion.xuanniao.account.login.view.LoginActivity");
                intent.putExtra("isFinish", true);
                intent.putExtra("source", authRequest.getAuthParam().getPkgName());
                intent.putExtra("auth_request", authRequest.getAuthRequestId());
                if ("tech.palm.id".equals(this.mContext.getPackageName())) {
                    intent.addFlags(0x10008000);
                } else {
                    intent.addFlags(0x10000000);
                }
                this.mContext.startActivity(intent);
            }
        }
        catch (Exception e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            authRequest.setException(40102, "palm id app error");
        }
    }

    public void handleStatusRequest(PalmAuthRequest authRequest) {
        block6: {
            this.addAuthRequest(authRequest);
            try {
                boolean isLogged = XNManager.getInstance().isLogged(this.mContext);
                PalmUtil.LOG.d((Object)("isLogged = " + isLogged));
                if (isLogged) {
                    Bundle bundle = new Bundle();
                    try {
                        String accountInfo = XNManager.getInstance().getAccountInfo(this.mContext);
                        if (!TextUtils.isEmpty((CharSequence)accountInfo)) {
                            JSONObject jsonObject = new JSONObject(accountInfo);
                            bundle.putString("user_info", new JSONObject().put("nickName", (Object)jsonObject.optString("nickname")).put("userName", (Object)jsonObject.optString("username")).put("avatarUrl", (Object)jsonObject.optString("avatarUrl")).toString());
                            bundle.putString("logged_id", String.valueOf(jsonObject.getString("xuanniaoId").hashCode()));
                        }
                    }
                    catch (Exception e) {
                        PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                    }
                    authRequest.setResult(bundle);
                    break block6;
                }
                Bundle bundle = new Bundle();
                bundle.putInt("status", -102);
                authRequest.setResult(bundle);
            }
            catch (Exception e) {
                PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                authRequest.setException(40102, "palm id app error");
            }
        }
    }

    public void addAuthRequest(PalmAuthRequest authRequest) {
        authRequest.setAuthManager(this);
        this.mAuthRequestMap.put(authRequest.getAuthRequestId(), authRequest);
        PalmUtil.LOG.d((Object)("begin request id = " + authRequest.getAuthRequestId()));
    }

    public void removeAuthRequest(String requestId) {
        this.mAuthRequestMap.remove(requestId);
        PalmUtil.LOG.d((Object)("end request id = " + requestId));
    }

    public PalmAuthRequest getAuthRequest(String requestId) {
        if (TextUtils.isEmpty((CharSequence)requestId)) {
            return null;
        }
        return this.mAuthRequestMap.get(requestId);
    }
}

