/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.auth;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.transsion.palmsdk.PalmAuthParam;
import com.transsion.palmsdk.auth.IPalmAuthResponse;
import com.transsion.palmsdk.auth.IPalmAuthService;
import com.transsion.palmsdk.auth.PalmAuthManager;
import com.transsion.palmsdk.data.PalmAuthRequest;
import com.transsion.palmsdk.util.PalmUtil;
import com.transsion.palmsdk.util.ThreadExecutors;

public class PalmAuthService
extends Service {
    private Context mContext;
    private final IPalmAuthService.Stub mStub = new IPalmAuthService.Stub(){

        @Override
        public void authorize(Bundle param, IPalmAuthResponse response) throws RemoteException {
            try {
                param.setClassLoader(this.getClass().getClassLoader());
                PalmAuthParam palmAuthParam = (PalmAuthParam)param.getParcelable("auth_param");
                if (palmAuthParam == null) {
                    if (response != null) {
                        Bundle bundle = new Bundle();
                        bundle.putInt("error_code", 40101);
                        bundle.putString("error_message", "invalid arguments");
                        response.setResult(bundle);
                    }
                    return;
                }
                PalmAuthRequest palmAuthRequest = new PalmAuthRequest(palmAuthParam, false, response);
                palmAuthRequest.setHostMode(param.getBoolean("host_mode", false));
                ThreadExecutors.getInstance().execute(new PalmAuthRunnable(palmAuthRequest));
            }
            catch (Exception e) {
                PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
        }

        @Override
        public void getPalmStatus(Bundle param, IPalmAuthResponse response) throws RemoteException {
            try {
                param.setClassLoader(this.getClass().getClassLoader());
                PalmAuthParam palmAuthParam = (PalmAuthParam)param.getParcelable("auth_param");
                if (palmAuthParam == null) {
                    if (response != null) {
                        Bundle bundle = new Bundle();
                        bundle.putInt("status", -109);
                        response.setResult(bundle);
                    }
                    return;
                }
                ThreadExecutors.getInstance().execute(new PalmStatusRunnable(new PalmAuthRequest(palmAuthParam, false, response)));
            }
            catch (Exception e) {
                PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
        }
    };

    public void onCreate() {
        this.mContext = this.getApplicationContext();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.mStub;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 2;
    }

    private class PalmStatusRunnable
    implements Runnable {
        private final PalmAuthRequest palmAuthRequest;

        private PalmStatusRunnable(PalmAuthRequest palmAuthRequest) {
            this.palmAuthRequest = palmAuthRequest;
        }

        @Override
        public void run() {
            PalmAuthManager.getInstance(PalmAuthService.this.mContext).handleStatusRequest(this.palmAuthRequest);
        }
    }

    private class PalmAuthRunnable
    implements Runnable {
        private final PalmAuthRequest palmAuthRequest;

        private PalmAuthRunnable(PalmAuthRequest palmAuthRequest) {
            this.palmAuthRequest = palmAuthRequest;
        }

        @Override
        public void run() {
            PalmAuthManager.getInstance(PalmAuthService.this.mContext).handleAuthRequest(this.palmAuthRequest);
        }
    }
}

