/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.auth;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.palmsdk.PalmID;
import com.transsion.palmsdk.auth.IPalmAuthResponse;
import com.transsion.palmsdk.auth.IPalmAuthService;
import com.transsion.palmsdk.data.PalmAuthResult;
import com.transsion.palmsdk.util.PalmUtil;

public class PalmAuthSession
implements ServiceConnection {
    private IPalmAuthService mAuthService;
    private final Context mContext;
    private final Intent mPalmIntent;
    private final Bundle mParam;
    private final PalmID.IPalmAuthListener mPalmAuthListener;
    private final IPalmAuthResponse.Stub mPalmAuthResponse = new IPalmAuthResponse.Stub(){

        @Override
        public void onCancel() throws RemoteException {
            PalmAuthSession.this.unbind();
            if (PalmAuthSession.this.mPalmAuthListener != null) {
                PalmAuthSession.this.mPalmAuthListener.onCancel();
            }
        }

        @Override
        public void setResult(Bundle result) throws RemoteException {
            PalmAuthSession.this.unbind();
            result.setClassLoader(this.getClass().getClassLoader());
            if (result.containsKey("token_info")) {
                if (PalmAuthSession.this.mPalmAuthListener != null) {
                    PalmAuthSession.this.mPalmAuthListener.onSuccess(new PalmAuthResult(result));
                }
            } else {
                int errorCode = result.getInt("error_code", 0);
                String errorMessage = result.getString("error_message");
                if (PalmAuthSession.this.mPalmAuthListener != null) {
                    PalmAuthSession.this.mPalmAuthListener.onFailure(errorCode, errorMessage);
                }
            }
        }
    };

    public PalmAuthSession(Context context, Intent palmIntent, Bundle param, PalmID.IPalmAuthListener palmAuthListener, boolean isMProcess) {
        this.mContext = context;
        this.mPalmIntent = palmIntent;
        this.mParam = param;
        this.mPalmAuthListener = palmAuthListener;
    }

    public boolean create() {
        try {
            if (Build.VERSION.SDK_INT >= 34) {
                return this.mContext.bindService(this.mPalmIntent, (ServiceConnection)this, 513);
            }
            return this.mContext.bindService(this.mPalmIntent, (ServiceConnection)this, 1);
        }
        catch (Exception e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    private void unbind() {
        if (this.mAuthService != null) {
            this.mAuthService = null;
            this.mContext.unbindService((ServiceConnection)this);
        }
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        block2: {
            PalmUtil.LOG.d((Object)"onServiceConnected");
            try {
                this.mAuthService = IPalmAuthService.Stub.asInterface(service);
                this.mAuthService.authorize(this.mParam, this.mPalmAuthResponse);
            }
            catch (Exception e) {
                PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                if (this.mPalmAuthListener == null) break block2;
                this.mPalmAuthListener.onFailure(40102, "remote exception");
            }
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.mAuthService = null;
        if (this.mPalmAuthListener != null) {
            this.mPalmAuthListener.onFailure(40102, "service disconnected");
        }
    }
}

