/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.palmsdk.PalmAuthParam;
import com.transsion.palmsdk.auth.IPalmAuthResponse;
import com.transsion.palmsdk.auth.PalmAuthManager;
import com.transsion.palmsdk.util.PalmUtil;

public class PalmAuthRequest
implements Parcelable {
    private final String authRequestId;
    private final boolean isFullSDK;
    private final PalmAuthParam palmAuthParam;
    private final IPalmAuthResponse response;
    private PalmAuthManager authManager;
    private boolean isSilentMode = false;
    private boolean isHostMode = false;
    public static final Parcelable.Creator<PalmAuthRequest> CREATOR = new Parcelable.Creator<PalmAuthRequest>(){

        public PalmAuthRequest createFromParcel(Parcel in) {
            return new PalmAuthRequest(in);
        }

        public PalmAuthRequest[] newArray(int size) {
            return new PalmAuthRequest[size];
        }
    };

    public PalmAuthRequest(PalmAuthParam palmAuthParam, boolean isFullSDK, IPalmAuthResponse response) {
        this.palmAuthParam = palmAuthParam;
        this.isFullSDK = isFullSDK;
        this.response = response;
        this.authRequestId = PalmUtil.randomString(8);
    }

    protected PalmAuthRequest(Parcel in) {
        this.authRequestId = in.readString();
        this.isFullSDK = in.readInt() == 1;
        this.isSilentMode = in.readInt() == 1;
        this.palmAuthParam = (PalmAuthParam)in.readParcelable(PalmAuthParam.class.getClassLoader());
        this.response = IPalmAuthResponse.Stub.asInterface(in.readStrongBinder());
        this.isHostMode = in.readInt() == 1;
    }

    public PalmAuthParam getAuthParam() {
        return this.palmAuthParam;
    }

    public String getAuthRequestId() {
        return this.authRequestId;
    }

    public boolean isFullSDK() {
        return this.isFullSDK;
    }

    public void setSilentMode(boolean silentMode) {
        this.isSilentMode = silentMode;
    }

    public boolean isSilentMode() {
        return this.isSilentMode;
    }

    public void setHostMode(boolean hostMode) {
        this.isHostMode = hostMode;
    }

    public boolean isHostMode() {
        return this.isHostMode;
    }

    public boolean showPrevLogin() {
        return !this.isHostMode && this.palmAuthParam.isShowPrevLogin();
    }

    public void onCancel() {
        try {
            if (this.response != null) {
                this.response.onCancel();
            }
        }
        catch (Exception e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        this.finishRequest();
    }

    public void setResult(Bundle bundle) {
        try {
            if (this.response != null) {
                this.response.setResult(bundle);
            }
        }
        catch (Exception e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        this.finishRequest();
    }

    public void setException(int errorCode, String errorMessage) {
        try {
            if (this.isHostMode) {
                errorCode = 49999;
            }
            if (this.response != null) {
                Bundle bundle = new Bundle();
                bundle.putInt("error_code", errorCode);
                bundle.putString("error_message", errorMessage);
                this.response.setResult(bundle);
            }
        }
        catch (RemoteException e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        this.finishRequest();
    }

    public void setAuthManager(PalmAuthManager authManager) {
        this.authManager = authManager;
    }

    private void finishRequest() {
        if (this.authManager != null) {
            this.authManager.removeAuthRequest(this.authRequestId);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.authRequestId);
        dest.writeInt(this.isFullSDK ? 1 : 0);
        dest.writeInt(this.isSilentMode ? 1 : 0);
        dest.writeParcelable((Parcelable)this.palmAuthParam, flags);
        dest.writeStrongBinder(this.response.asBinder());
        dest.writeInt(this.isHostMode ? 1 : 0);
    }
}

