/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.data;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.transsion.palmsdk.data.PalmAccountInfo;
import com.transsion.palmsdk.data.PalmAuthCodeInfo;
import com.transsion.palmsdk.data.PalmAuthInfo;
import com.transsion.palmsdk.data.PalmTokenInfo;
import com.transsion.palmsdk.data.PalmUserInfo;
import java.io.Serializable;
import org.json.JSONObject;

public class PalmAuthResult
implements Serializable {
    private PalmUserInfo userInfo;
    private PalmAuthInfo authInfo;

    public PalmAuthResult(Bundle bundle) {
        String tokenJson;
        String userJson = bundle.getString("user_info");
        if (!TextUtils.isEmpty((CharSequence)userJson)) {
            this.userInfo = userJson.contains("phone") || userJson.contains("email") ? new PalmAccountInfo(userJson) : new PalmUserInfo(userJson);
        }
        if (!TextUtils.isEmpty((CharSequence)(tokenJson = bundle.getString("token_info")))) {
            this.authInfo = tokenJson.contains("auth_code") ? new PalmAuthCodeInfo(tokenJson) : new PalmTokenInfo(tokenJson);
        }
    }

    public PalmAuthResult(String token, String accountInfo) {
        String openId = null;
        if (!TextUtils.isEmpty((CharSequence)accountInfo)) {
            PalmAccountInfo accInfo = new PalmAccountInfo(accountInfo);
            openId = accInfo.openId;
            this.userInfo = accInfo;
        }
        try {
            this.authInfo = new PalmTokenInfo(new JSONObject().put("access_token", (Object)token).put("open_id", (Object)openId).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getOpenid() {
        if (this.authInfo instanceof PalmAuthCodeInfo) {
            return ((PalmAuthCodeInfo)this.authInfo).openid;
        }
        if (this.authInfo instanceof PalmTokenInfo) {
            return ((PalmTokenInfo)this.authInfo).openid;
        }
        return null;
    }

    public String getNickName() {
        return this.userInfo != null ? this.userInfo.nickName : null;
    }

    public String getAvatarUrl() {
        return this.userInfo != null ? this.userInfo.avatarUrl : null;
    }

    public String getUserName() {
        return this.userInfo != null ? this.userInfo.userName : null;
    }

    public String getAuthCode() {
        if (this.authInfo instanceof PalmAuthCodeInfo) {
            return ((PalmAuthCodeInfo)this.authInfo).authCode;
        }
        return null;
    }

    public String getAccessToken() {
        if (this.authInfo instanceof PalmTokenInfo) {
            return ((PalmTokenInfo)this.authInfo).access_token;
        }
        return null;
    }

    public String getRefreshToken() {
        if (this.authInfo instanceof PalmTokenInfo) {
            return ((PalmTokenInfo)this.authInfo).refresh_token;
        }
        return null;
    }

    public int getExpiresIn() {
        if (this.authInfo instanceof PalmTokenInfo) {
            return ((PalmTokenInfo)this.authInfo).expires_in;
        }
        return 0;
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.userInfo != null) {
            builder.append("userName = ").append(this.userInfo.userName).append(";").append("nickName = ").append(this.userInfo.nickName).append(";");
        }
        if (this.authInfo != null) {
            if (this.authInfo instanceof PalmAuthCodeInfo) {
                PalmAuthCodeInfo codeInfo = (PalmAuthCodeInfo)this.authInfo;
                builder.append("auth_code = ").append(codeInfo.authCode).append(";");
            } else {
                PalmTokenInfo tokenInfo = (PalmTokenInfo)this.authInfo;
                builder.append("access_token = ").append(tokenInfo.access_token).append(";");
            }
        }
        return builder.toString();
    }
}

