/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.transsion.palmsdk.data.PalmAuthInfo;
import com.transsion.palmsdk.util.PalmUtil;
import org.json.JSONObject;

public class PalmTokenInfo
extends PalmAuthInfo
implements Parcelable {
    public String access_token;
    public int expires_in;
    public String refresh_token;
    public String openid;
    private long update_time;
    public static final Parcelable.Creator<PalmTokenInfo> CREATOR = new Parcelable.Creator<PalmTokenInfo>(){

        public PalmTokenInfo createFromParcel(Parcel in) {
            return new PalmTokenInfo(in);
        }

        public PalmTokenInfo[] newArray(int size) {
            return new PalmTokenInfo[size];
        }
    };

    public PalmTokenInfo(String jsonData) {
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            if (jsonObject.has("token")) {
                this.access_token = jsonObject.optString("token");
                this.refresh_token = jsonObject.optString("refreshToken");
            } else {
                this.access_token = jsonObject.optString("access_token");
                this.refresh_token = jsonObject.optString("refresh_token");
                this.expires_in = jsonObject.optInt("expires_in", 7199);
                this.openid = jsonObject.optString("open_id");
                this.update_time = jsonObject.optLong("update_time");
            }
        }
        catch (Exception e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
    }

    public PalmTokenInfo(PalmTokenInfo tokenInfo) {
        this.access_token = tokenInfo.access_token;
        this.expires_in = tokenInfo.expires_in;
        this.refresh_token = tokenInfo.refresh_token;
        this.openid = tokenInfo.openid;
        this.update_time = tokenInfo.update_time;
    }

    public long getLastUpdateTime() {
        return this.update_time;
    }

    public long getExpireTime() {
        return (long)this.expires_in * 1000L;
    }

    public String toJson() {
        try {
            return new JSONObject().put("access_token", (Object)this.access_token).put("refresh_token", (Object)this.refresh_token).put("open_id", (Object)this.openid).toString();
        }
        catch (Exception e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    protected PalmTokenInfo(Parcel in) {
        this.access_token = in.readString();
        this.refresh_token = in.readString();
        this.openid = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.access_token);
        dest.writeString(this.refresh_token);
        dest.writeString(this.openid);
    }
}

