/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.http;

import android.text.TextUtils;
import android.util.Log;
import com.transsion.gslb.GslbSdk;
import com.transsion.palmsdk.PalmConstants;
import com.transsion.palmsdk.data.PalmTokenInfo;
import com.transsion.palmsdk.exception.PalmServerException;
import com.transsion.palmsdk.http.PalmHttpCallback;
import com.transsion.palmsdk.http.SSLContextUtil;
import com.transsion.palmsdk.util.PalmUtil;
import com.transsion.palmsdk.util.ThreadExecutors;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONObject;

public class PalmHttpClient {
    private static PalmHttpClient sPalmHttpClient;
    private static SSLSocketFactory sslSocketFactory;
    private final int serverMode = PalmConstants.SERVER_MODE;
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    public static final String PATH_AUTH_CODE = "/oauth/authorize";
    public static final String PATH_AUTH_CODE_CONFIRM = "/oauth/authorize_confirm";
    public static final String PATH_ACCESS_TOKEN = "/client/token";
    public static final String PATH_PALM_CENTER = "/palmid/sdk/#/user-center";
    public static final String PATH_USER_PROFILE = "/palmid/sdk/#/user-profile";
    public static final String PATH_BIND_PHONE = "/palmid/sdk/#/bind-phone";
    public static final String PATH_EXPIRE_TOKEN = "/openapi/user/expire-token";
    public static final int SUCCESS = 200;
    public static final int ERROR_PARAM = 400;
    public static final int TOKEN_TIMEOUT = 40055;
    public static final int PERMISSION_DENIED = 401400;
    public static final int AUTH_TOKEN_TIME_OUT = 401401;
    public static final int NEED_TO_LOGIN = 400006;
    public static final int CLOUD_SYNC_CONFLICT = 10000003;

    private PalmHttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PalmHttpClient getInstance() {
        if (sPalmHttpClient != null) return sPalmHttpClient;
        Class<PalmHttpClient> clazz = PalmHttpClient.class;
        synchronized (PalmHttpClient.class) {
            if (sPalmHttpClient != null) return sPalmHttpClient;
            sPalmHttpClient = new PalmHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sPalmHttpClient;
        }
    }

    public String getBaseUrl() {
        String baseUrl = "https://account.palm.tech";
        if (this.serverMode == 1) {
            baseUrl = "https://dev-account.palm.tech";
        } else if (this.serverMode == 2) {
            baseUrl = "https://test-account.palm.tech";
        } else if (this.serverMode == 3) {
            baseUrl = "https://pre-account.palm.tech";
        }
        return GslbSdk.getDomain((String)baseUrl, (boolean)true);
    }

    public String getFullUrl(String path, Map<String, Object> params) {
        return this.getBaseUrl() + path + (params == null ? "" : "?" + PalmUtil.urlEncodeUTF8(params));
    }

    public String getPalmAppConfig(Map<String, String> header, Map<String, Object> formData) {
        try {
            return this.doPost(this.getBaseUrl() + "/app/cloud/config", header, formData);
        }
        catch (Exception e) {
            PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public void callOpenApi(final String path, final Map<String, String> header, final Map<String, Object> formData, final PalmHttpCallback<String> callback) {
        ThreadExecutors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String response = formData == null || formData.size() == 0 ? PalmHttpClient.this.doGet(PalmHttpClient.this.getBaseUrl() + path, header, null) : PalmHttpClient.this.doPost(PalmHttpClient.this.getBaseUrl() + path, header, formData);
                    callback.onSuccess(response);
                }
                catch (Exception e) {
                    if (e instanceof PalmServerException) {
                        PalmServerException exception = (PalmServerException)e;
                        callback.onFailure(exception.errorCode, exception.errorMessage);
                    }
                    callback.onFailure(40103, e.getMessage());
                }
            }
        });
    }

    public void getAuthCodeConfirm(final Map<String, String> header, final Map<String, Object> formData, final PalmHttpCallback<String> callback) {
        ThreadExecutors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String response = PalmHttpClient.this.doPost(PalmHttpClient.this.getBaseUrl() + PalmHttpClient.PATH_AUTH_CODE_CONFIRM, header, formData);
                    callback.onSuccess(response);
                }
                catch (Exception e) {
                    if (e instanceof PalmServerException) {
                        PalmServerException exception = (PalmServerException)e;
                        callback.onFailure(exception.errorCode, exception.errorMessage);
                    }
                    callback.onFailure(40103, e.getMessage());
                }
            }
        });
    }

    public void getAuthCode(final Map<String, String> header, final Map<String, Object> params, final PalmHttpCallback<String> callback) {
        ThreadExecutors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String response = PalmHttpClient.this.doGet(PalmHttpClient.this.getBaseUrl() + PalmHttpClient.PATH_AUTH_CODE, header, params);
                    callback.onSuccess(response);
                }
                catch (Exception e) {
                    if (e instanceof PalmServerException) {
                        PalmServerException exception = (PalmServerException)e;
                        callback.onFailure(exception.errorCode, exception.errorMessage);
                    }
                    callback.onFailure(40103, e.getMessage());
                }
            }
        });
    }

    public void getAccessToken(final Map<String, Object> params, final PalmHttpCallback<String> callback) {
        ThreadExecutors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String response = PalmHttpClient.this.doGet(PalmHttpClient.this.getBaseUrl() + PalmHttpClient.PATH_ACCESS_TOKEN, null, params);
                    callback.onSuccess(response);
                }
                catch (Exception e) {
                    if (e instanceof PalmServerException) {
                        PalmServerException exception = (PalmServerException)e;
                        callback.onFailure(exception.errorCode, exception.errorMessage);
                    }
                    callback.onFailure(40103, e.getMessage());
                }
            }
        });
    }

    public void refreshToken(final Map<String, Object> params, final PalmHttpCallback<PalmTokenInfo> callback) {
        ThreadExecutors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String response = PalmHttpClient.this.doGet(PalmHttpClient.this.getBaseUrl() + PalmHttpClient.PATH_ACCESS_TOKEN, null, params);
                    callback.onSuccess(new PalmTokenInfo(response));
                }
                catch (Exception e) {
                    if (e instanceof PalmServerException) {
                        PalmServerException exception = (PalmServerException)e;
                        callback.onFailure(exception.errorCode, exception.errorMessage);
                    }
                    callback.onFailure(40103, e.getMessage());
                }
            }
        });
    }

    public void expireToken(final Map<String, String> header, final Map<String, Object> params, final PalmHttpCallback<String> callback) {
        ThreadExecutors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String response = PalmHttpClient.this.doGet(PalmHttpClient.this.getBaseUrl() + PalmHttpClient.PATH_EXPIRE_TOKEN, header, params);
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }
                catch (Exception e) {
                    if (e instanceof PalmServerException) {
                        PalmServerException exception = (PalmServerException)e;
                        callback.onFailure(exception.errorCode, exception.errorMessage);
                    }
                    callback.onFailure(-1, e.getMessage());
                }
            }
        });
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private String doGet(String urlString, Map<String, String> header, Map<String, Object> params) throws Exception {
        urlConnection = null;
        try {
            if (params != null && params.size() > 0) {
                urlString = urlString + "?" + PalmUtil.urlEncodeUTF8(params);
            }
            PalmUtil.LOG.d((Object)("doGet url = " + urlString));
            url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            if (urlConnection instanceof HttpsURLConnection) {
                if (PalmHttpClient.sslSocketFactory == null && (sslContext = SSLContextUtil.getSSLContext()) != null) {
                    PalmHttpClient.sslSocketFactory = sslContext.getSocketFactory();
                }
                if (PalmHttpClient.sslSocketFactory != null) {
                    ((HttpsURLConnection)urlConnection).setSSLSocketFactory(PalmHttpClient.sslSocketFactory);
                    ((HttpsURLConnection)urlConnection).setHostnameVerifier(SSLContextUtil.myHostNameVerifier);
                }
            }
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("accept", "*/*");
            urlConnection.setInstanceFollowRedirects(false);
            if (header != null && header.size() > 0) {
                for (Map.Entry entry : header.entrySet()) {
                    if (TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey())) || TextUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
                    urlConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            urlConnection.setRequestMethod("GET");
            urlConnection.setReadTimeout(30000);
            urlConnection.setConnectTimeout(30000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            responseCode = urlConnection.getResponseCode();
            PalmUtil.LOG.d((Object)("doGet responseCode = " + responseCode));
            if (responseCode == 200) {
                is = urlConnection.getInputStream();
                bf = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                buffer = new StringBuilder();
                while ((line = bf.readLine()) != null) {
                    buffer.append(line);
                }
                bf.close();
                is.close();
                var12_23 = response = buffer.toString();
                return var12_23;
            }
            if (responseCode != 301 && responseCode != 302 && responseCode != 303) ** GOTO lbl58
            response = urlConnection.getHeaderField("Location");
            bundle = PalmUtil.urlParse(response);
            if (bundle == null) {
                throw new PalmServerException(40104, "unknown server error");
            }
            code = bundle.getString("code", null);
            state = bundle.getString("state", null);
            if (code != null) {
                response = new JSONObject().put("code", (Object)code).put("state", (Object)state).toString();
                return response;
            }
            try {
                error = bundle.getString("errorCode");
                errorCode = 40104;
                if (error.startsWith("400")) {
                    errorCode = Integer.parseInt(error);
                }
                errorMessage = bundle.getString("error_description");
                throw new PalmServerException(errorCode, errorMessage);
lbl58:
                // 1 sources

                bf = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), Charset.forName("UTF-8")));
                buffer = new StringBuilder();
                while ((line = bf.readLine()) != null) {
                    buffer.append(line);
                }
                bf.close();
                response = buffer.toString();
                PalmUtil.LOG.d((Object)("doGet response = " + response));
                errorCode = responseCode;
                errorMessage = "unknown server error";
                try {
                    errorJson = new JSONObject(response);
                    if (errorJson.has("code")) {
                        errorCode = errorJson.optInt("code", errorCode);
                        errorMessage = errorJson.optString("message");
                    } else if (errorJson.has("status")) {
                        errorCode = errorJson.optInt("status", errorCode);
                        errorMessage = errorJson.optString("message");
                    }
                    if (errorCode == 40055) {
                        errorMessage = "token expired";
                    }
                }
                catch (Exception var13_28) {
                    // empty catch block
                }
                throw new PalmServerException(errorCode, errorMessage);
            }
            catch (Exception e) {
                if (e instanceof UnknownHostException) {
                    PalmUtil.LOG.e((Object)e.getMessage());
                } else if (!(e instanceof PalmServerException)) {
                    PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                throw e;
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private String doPost(String urlString, Map<String, String> header, Map<String, Object> formData) throws Exception {
        urlConnection = null;
        try {
            PalmUtil.LOG.d((Object)("doPost url = " + urlString));
            url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            if (urlConnection instanceof HttpsURLConnection) {
                if (PalmHttpClient.sslSocketFactory == null && (sslContext = SSLContextUtil.getSSLContext()) != null) {
                    PalmHttpClient.sslSocketFactory = sslContext.getSocketFactory();
                }
                if (PalmHttpClient.sslSocketFactory != null) {
                    ((HttpsURLConnection)urlConnection).setSSLSocketFactory(PalmHttpClient.sslSocketFactory);
                    ((HttpsURLConnection)urlConnection).setHostnameVerifier(SSLContextUtil.myHostNameVerifier);
                }
            }
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("accept", "*/*");
            urlConnection.setInstanceFollowRedirects(false);
            if (header != null && header.size() > 0) {
                for (Object entry : header.entrySet()) {
                    if (TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey())) || TextUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
                    urlConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            urlConnection.setRequestMethod("POST");
            urlConnection.setReadTimeout(30000);
            urlConnection.setConnectTimeout(30000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            builder = new StringBuilder();
            if (formData != null) {
                for (Map.Entry entry : formData.entrySet()) {
                    if (builder.length() == 0) {
                        builder.append((String)entry.getKey()).append("=").append(entry.getValue());
                        continue;
                    }
                    builder.append("&").append((String)entry.getKey()).append("=").append(entry.getValue());
                }
            }
            PalmUtil.LOG.d((Object)("doPost formData = " + builder.toString()));
            printWriter = new PrintWriter(urlConnection.getOutputStream());
            printWriter.write(builder.toString());
            printWriter.flush();
            printWriter.close();
            responseCode = urlConnection.getResponseCode();
            PalmUtil.LOG.d((Object)("doPost responseCode = " + responseCode));
            if (responseCode == 200) {
                is = urlConnection.getInputStream();
                bf = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                buffer = new StringBuilder();
                while ((line = bf.readLine()) != null) {
                    buffer.append(line);
                }
                bf.close();
                is.close();
                var14_27 = response = buffer.toString();
                return var14_27;
            }
            if (responseCode != 301 && responseCode != 302 && responseCode != 303) ** GOTO lbl71
            response = urlConnection.getHeaderField("Location");
            bundle = PalmUtil.urlParse(response);
            if (bundle == null) {
                throw new PalmServerException(40104, "unknown server error");
            }
            code = bundle.getString("code", null);
            state = bundle.getString("state", null);
            if (code != null) {
                response = new JSONObject().put("code", (Object)code).put("state", (Object)state).toString();
                return response;
            }
            try {
                error = bundle.getString("errorCode");
                errorCode = 40104;
                if (error.startsWith("400")) {
                    errorCode = Integer.parseInt(error);
                }
                errorMessage = bundle.getString("error_description");
                throw new PalmServerException(errorCode, errorMessage);
lbl71:
                // 1 sources

                bf = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), Charset.forName("UTF-8")));
                buffer = new StringBuilder();
                while ((line = bf.readLine()) != null) {
                    buffer.append(line);
                }
                bf.close();
                response = buffer.toString();
                PalmUtil.LOG.d((Object)("doPost response = " + response));
                errorCode = responseCode;
                errorMessage = "unknown server error";
                try {
                    errorJson = new JSONObject(response);
                    if (errorJson.has("code")) {
                        errorCode = errorJson.optInt("code", errorCode);
                        errorMessage = errorJson.optString("message");
                    } else if (errorJson.has("status")) {
                        errorCode = errorJson.optInt("status", errorCode);
                        errorMessage = errorJson.optString("message");
                    }
                    if (errorCode == 40055) {
                        errorMessage = "token expired";
                    }
                }
                catch (Exception var15_32) {
                    // empty catch block
                }
                throw new PalmServerException(errorCode, errorMessage);
            }
            catch (Exception e) {
                if (e instanceof UnknownHostException) {
                    PalmUtil.LOG.e((Object)e.getMessage());
                } else if (!(e instanceof PalmServerException)) {
                    PalmUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                throw e;
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    static {
        sslSocketFactory = null;
    }
}

