/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.http;

import android.annotation.TargetApi;
import android.net.SSLCertificateSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

@TargetApi(value=17)
public class SSLContextUtil {
    public static MyHostNameVerifier myHostNameVerifier = new MyHostNameVerifier();

    public static SSLContext getSSLContext() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    try {
                        chain[0].checkValidity();
                    }
                    catch (Exception e) {
                        throw new CertificateException("Certificate not valid or trusted.");
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sslContext;
    }

    static class MyHostNameVerifier
    implements HostnameVerifier {
        private HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return this.hostnameVerifier.verify(hostname, session);
        }
    }

    static class MySSLSocketFactory
    extends SSLSocketFactory {
        private String orgUrl;

        public MySSLSocketFactory setOrgUrl(String orgUrl) {
            this.orgUrl = orgUrl;
            return this;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return new String[0];
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return new String[0];
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            SSLCertificateSocketFactory sslSocketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)0);
            SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(s, this.orgUrl, port, autoClose);
            sslSocket.setEnabledProtocols(sslSocket.getSupportedProtocols());
            sslSocketFactory.setHostname((Socket)sslSocket, this.orgUrl);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return null;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return null;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return null;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return null;
        }
    }
}

