/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.tudc;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.transsion.palmsdk.util.PalmUtil;
import net.grandcentrix.tray.AppPreferences;

public class TudcAccount {
    private static TudcAccount sTudcAccount;
    private static final String TAG_TOKEN = "TOKEN";
    private static final String TAG_OPENID = "OPENID";
    private final String tudcSpName;
    private String token;
    private long openId;
    private AppPreferences appPreferences;

    private TudcAccount(String spName) {
        this.tudcSpName = spName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TudcAccount getInstance(String spName) {
        if (sTudcAccount != null) return sTudcAccount;
        Class<TudcAccount> clazz = TudcAccount.class;
        synchronized (TudcAccount.class) {
            if (sTudcAccount != null) return sTudcAccount;
            sTudcAccount = new TudcAccount(spName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sTudcAccount;
        }
    }

    public boolean isLogged(Context context) {
        if (TextUtils.isEmpty((CharSequence)this.tudcSpName)) {
            if (this.appPreferences == null) {
                this.appPreferences = new AppPreferences(context);
            }
            this.token = this.appPreferences.getString(TAG_TOKEN, "");
            this.openId = this.appPreferences.getLong(TAG_OPENID, 0L);
        } else {
            SharedPreferences sp = context.getSharedPreferences(this.tudcSpName, 0);
            this.token = sp.getString("token", "");
            this.openId = sp.getLong("openid", 0L);
        }
        return this.token.length() > 0 && this.openId > 0L;
    }

    public void clear(Context context) {
        if (TextUtils.isEmpty((CharSequence)this.token)) {
            return;
        }
        this.token = "";
        this.openId = 0L;
        if (TextUtils.isEmpty((CharSequence)this.tudcSpName)) {
            if (this.appPreferences == null) {
                this.appPreferences = new AppPreferences(context);
            }
            this.appPreferences.remove(TAG_TOKEN);
            this.appPreferences.remove(TAG_OPENID);
        } else {
            SharedPreferences sp = context.getSharedPreferences(this.tudcSpName, 0);
            sp.edit().putString("token", "").putLong("openid", 0L).apply();
        }
        PalmUtil.LOG.d((Object)"tudc token clear");
    }

    public String getTudcToken() {
        return this.token;
    }
}

