/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.palmsdk.util;

import android.app.ActivityManager;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.log.ObjectLogUtils;
import com.transsion.palmsdk.util.AdvertisingIdClient;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.json.JSONObject;

public class PalmUtil {
    public static ObjectLogUtils LOG = new ObjectLogUtils.Builder().setGlobalTag("PalmSDK").setLogHeadSwitch(true).setLogSwitch(false).setBorderSwitch(false).create();

    public static String urlEncodeUTF8(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (builder.length() > 0) {
                    builder.append("&");
                }
                builder.append(String.format("%s=%s", URLEncoder.encode(entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue().toString(), "UTF-8")));
            }
        }
        catch (Exception e) {
            LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        return builder.toString();
    }

    public static Bundle urlParse(String url) {
        int index = url.indexOf(63);
        if (index > 0) {
            String param = url.substring(index + 1);
            if (param.startsWith("code=") || param.contains("&code=")) {
                return PalmUtil.parseParam(param);
            }
            if (param.startsWith("error=") || param.contains("&error=")) {
                return PalmUtil.parseParam(param);
            }
        } else {
            int index2 = url.indexOf(35);
            if (index2 > 0) {
                String param = url.substring(index2 + 1);
                if (param.startsWith("access_token=") || param.contains("&access_token=")) {
                    return PalmUtil.parseParam(url.replace("#", "?"));
                }
                if (param.startsWith("error=") || param.contains("&error=")) {
                    return PalmUtil.parseParam(url.replace("#", "?"));
                }
            }
        }
        return null;
    }

    private static Bundle parseParam(String param) {
        Bundle bundle = new Bundle();
        if (param != null) {
            String[] params = param.split("&");
            for (int i = 0; i < params.length; ++i) {
                String[] p = params[i].split("=");
                if (p.length == 0) continue;
                try {
                    String key = URLDecoder.decode(p[0], "UTF-8");
                    if (TextUtils.isEmpty((CharSequence)key)) continue;
                    String value = p.length == 2 ? URLDecoder.decode(p[1], "UTF-8") : "";
                    bundle.putString(key, value);
                    continue;
                }
                catch (Exception e) {
                    LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
            }
        }
        return bundle;
    }

    public static String randomString(int length) {
        String str = "0123456789abcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(str.charAt(random.nextInt(36)));
        }
        return builder.toString();
    }

    public static String formatUrlHost(String url) {
        Uri uri = Uri.parse((String)url);
        return uri.getScheme() + "://" + uri.getHost();
    }

    public static String getAppSign(Context context, String type) {
        try {
            Signature[] signatureArray;
            int n;
            int n2;
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            MessageDigest digest = MessageDigest.getInstance(type);
            Signature[] signatures = packageInfo.signatures;
            if (signatures != null && (n2 = 0) < (n = (signatureArray = signatures).length)) {
                Signature signature = signatureArray[n2];
                byte[] digestBytes = digest.digest(signature.toByteArray());
                StringBuilder builder = new StringBuilder();
                for (byte digestByte : digestBytes) {
                    builder.append(Integer.toHexString(digestByte & 0xFF | 0x100).substring(1, 3));
                }
                return builder.toString().toUpperCase();
            }
        }
        catch (Exception e) {
            LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        return null;
    }

    public static boolean isNetworkAvailable(Context context) {
        block5: {
            ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (cm == null) {
                return false;
            }
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    NetworkCapabilities networkCapabilities;
                    Network activeNetwork = cm.getActiveNetwork();
                    if (activeNetwork != null && (networkCapabilities = cm.getNetworkCapabilities(activeNetwork)) != null) {
                        return networkCapabilities.hasTransport(1) || networkCapabilities.hasTransport(0) || networkCapabilities.hasTransport(4) || networkCapabilities.hasTransport(3);
                    }
                    break block5;
                }
                NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                return networkInfo != null && networkInfo.isConnected();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static String getLocalLanguage(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            Resources res = context.getResources();
            if (res != null) {
                return res.getConfiguration().getLocales().get(0).getLanguage();
            }
        } else {
            return Locale.getDefault().getLanguage();
        }
        return "";
    }

    public static String getLanguageWithCountry(Context context) {
        Locale locale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (TextUtils.isEmpty((CharSequence)country)) {
            return language;
        }
        return language + "-r" + country;
    }

    public static String getMcc() {
        String deviceOperator = DeviceInfo.getSimOperator();
        if (!TextUtils.isEmpty((CharSequence)deviceOperator) && deviceOperator.length() >= 3) {
            return deviceOperator.substring(0, 3);
        }
        return "";
    }

    public static String getAppVersion(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pi.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getOSVersion() {
        try {
            Class<?> cls = Class.forName("android.os.SystemProperties");
            Method method = cls.getMethod("get", String.class, String.class);
            String osVersion = (String)method.invoke(null, "ro.tranos.version", "");
            if (TextUtils.isEmpty((CharSequence)osVersion)) {
                osVersion = (String)method.invoke(null, "ro.os_product.version", "");
            }
            return osVersion;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getCurProcessName(Context context) {
        String processName = null;
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                processName = Application.getProcessName();
            } else {
                int pid = Process.myPid();
                ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                List appProcesses = activityManager.getRunningAppProcesses();
                if (appProcesses != null) {
                    for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                        if (appProcess.pid != pid) continue;
                        processName = appProcess.processName;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)processName)) {
            processName = context.getPackageName();
        }
        return processName;
    }

    public static Map<String, Object> genConfigParam(Context context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mcc", PalmUtil.getMcc());
        map.put("osVersion", PalmUtil.getOSVersion());
        map.put("buildNumber", Build.DISPLAY);
        map.put("androidVersion", Build.VERSION.RELEASE);
        map.put("brand", Build.BRAND);
        map.put("language", Locale.getDefault().getLanguage());
        map.put("appVersion", PalmUtil.getAppVersion(context));
        try {
            AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
            map.put("gaid", adInfo.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static Intent queryPalmAppIntent(Context context, boolean onlyPalmID) {
        block15: {
            Intent intent = new Intent("intent.action.PALM_ACCOUNT_AUTH");
            PackageManager packageManager = context.getPackageManager();
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo("tech.palm.id", 128);
                Bundle bundle = applicationInfo.metaData;
                if (bundle != null && bundle.getString("palm_sdk_version", "").compareTo("1.0.0.4") >= 0) {
                    intent.setPackage("tech.palm.id");
                    intent.putExtra("host_mode", false);
                    return intent;
                }
            }
            catch (Exception applicationInfo) {
                // empty catch block
            }
            try {
                SharedPreferences palmPrefs = context.getSharedPreferences("palm_config", 0);
                String palmAppConfig = palmPrefs.getString("palm_app_array", null);
                if (palmAppConfig != null && palmAppConfig.length() > 0) {
                    JSONObject palmAppJson = new JSONObject(palmAppConfig);
                    Iterator keys = palmAppJson.keys();
                    while (keys.hasNext()) {
                        String pkgName = (String)keys.next();
                        try {
                            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(pkgName, 128);
                            Bundle bundle = applicationInfo.metaData;
                            if (bundle == null || bundle.getString("palm_sdk_version", "").compareTo("1.0.0.4") < 0) continue;
                            intent.setPackage(pkgName);
                            intent.putExtra("host_mode", false);
                            return intent;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            catch (Exception palmPrefs) {
                // empty catch block
            }
            if (!onlyPalmID) {
                try {
                    String hostPalmApp = Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)"host_palm_app");
                    LOG.d((Object)("hostPalmApp = " + hostPalmApp));
                    if (TextUtils.isEmpty((CharSequence)hostPalmApp) || TextUtils.equals((CharSequence)hostPalmApp, (CharSequence)context.getPackageName())) break block15;
                    try {
                        ApplicationInfo applicationInfo = packageManager.getApplicationInfo(hostPalmApp, 128);
                        Bundle bundle = applicationInfo.metaData;
                        if (bundle != null && bundle.getString("palm_sdk_version", "").compareTo("1.0.0.4") >= 0) {
                            intent.setPackage(hostPalmApp);
                            intent.putExtra("host_mode", true);
                            return intent;
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
            }
        }
        return null;
    }
}

