package com.transsion.palmsdk.account;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.transsion.palmsdk.PalmConstants;
import com.transsion.palmsdk.util.PalmUtil;

/**
 * 应用内多进程共享登录状态+数据
 */
public class PalmAccProvider extends ContentProvider {

    public static String AUTHORITY;
    private static final UriMatcher MATCHER = new UriMatcher(UriMatcher.NO_MATCH);
    private static final int CODE_STATUS = 1;    //登录状态                 // 匹配码
    private static final int CODE_TOKEN = 2;    //token数据
    private static final int CODE_PROFILE = 3;    //用户数据
    private static final int CODE_LINKED = 4;    //关联关系

    @Override
    public boolean onCreate() {
        AUTHORITY = getContext().getPackageName() + ".PalmAccProvider";  // 安装执行
        MATCHER.addURI(AUTHORITY, "status", CODE_STATUS);
        MATCHER.addURI(AUTHORITY, "token", CODE_TOKEN);
        MATCHER.addURI(AUTHORITY, "profile", CODE_PROFILE);
        MATCHER.addURI(AUTHORITY, "linked", CODE_LINKED);
        return true;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        Context context = getContext();
        MatrixCursor cursor = null;
        PalmUtil.LOG.d("query uri = " + uri);
        switch (MATCHER.match(uri)) {
            case CODE_STATUS:
                int status = XNManager.getInstance().isLogged(context) ? 1 : 0;
                cursor = new MatrixCursor(new String[] { "status" }, 1);
                cursor.addRow(new Object[] { status });
                return cursor;
            case CODE_TOKEN:
                String token = XNManager.getInstance().getToken();
                cursor = new MatrixCursor(new String[] { "token" }, 1);
                cursor.addRow(new Object[] { token });
                return cursor;
            case CODE_PROFILE:
                String profile = XNManager.getInstance().getAccountInfo(context);
                cursor = new MatrixCursor(new String[] { "profile" }, 1);
                cursor.addRow(new Object[] { profile });
                return cursor;
        }
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        if (values == null) {
            return null;
        }
        try {
            switch (MATCHER.match(uri)) {
                case CODE_TOKEN:
                    String aToken = values.getAsString("aToken");
                    String rToken = values.getAsString("rToken");
                    if (!TextUtils.isEmpty(aToken) && !TextUtils.isEmpty(rToken)) {
                        XNManager.getInstance().setToken(getContext(), aToken, rToken);
                        PalmUtil.LOG.d("setToken success");
                    }
                    break;
                case CODE_LINKED:
                    String linkedPkg = values.getAsString("linkedPkg");
                    String linkedId = values.getAsString("linkedId");
                    String linkedBd = values.getAsString("linkedBd");
                    if (!TextUtils.isEmpty(linkedPkg) && !TextUtils.isEmpty(linkedId)) {
                        LiteTeeManager.instance(getContext())
                                .saveString(PalmConstants.EXTRA_LINKED_PKG, linkedPkg);
                        LiteTeeManager.instance(getContext())
                                .saveString(PalmConstants.EXTRA_LINKED_ID, linkedId);
                        if (linkedBd != null) {
                            LiteTeeManager.instance(getContext())
                                    .saveString(PalmConstants.EXTRA_LINKED_BD, linkedBd);
                        }
                        PalmUtil.LOG.d("setLinked success");
                    }
                    break;
            }
        } catch (Exception e) {
            PalmUtil.LOG.e(Log.getStackTraceString(e));
        }
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    /**
     * 返回ContentProvider地址
     * ${applicationId}.PalmAccProvider
     */
    public static String getAuthority(Context context) {
        return context.getPackageName() + ".PalmAccProvider";
    }
}
