package com.transsion.palmsdk.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

import com.transsion.palmsdk.util.PalmUtil;

import org.json.JSONObject;


/**
 * 完整登录结果
 */
class PalmAccountInfo extends PalmUserInfo implements Parcelable {

    public String phone;
    public String birthday;
    public int gender;//0:未知 1: Male 2:Female
    public String state;//地区
    public String city;
    public String country;
    public String profession;
    public String email;
    public boolean states;//1.正常 2.冻结
    public boolean existPassword;
    public String fullName;
    public String signature;
    public int usernameModifyRemainTimes;
    public String xuanniaoId;
    public boolean haveAddress;
    public String openId;

    public PalmAccountInfo() {

    }

    public PalmAccountInfo(String jsonData) {
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            nickName = jsonObject.optString("nickname");
            userName = jsonObject.optString("username");
            avatarUrl = jsonObject.optString("avatarUrl");

            phone = jsonObject.optString("phone");
            birthday = jsonObject.optString("birthday");
            gender = jsonObject.optInt("gender");
            state = jsonObject.optString("state");
            city = jsonObject.optString("city");
            country = jsonObject.optString("country");
            profession = jsonObject.optString("profession");
            email = jsonObject.optString("email");
            states = jsonObject.optBoolean("states");
            existPassword = jsonObject.optBoolean("existPassword");
            fullName = jsonObject.optString("fullName");
            signature = jsonObject.optString("signature");
            usernameModifyRemainTimes = jsonObject.optInt("usernameModifyRemainTimes");
            xuanniaoId = jsonObject.optString("xuanniaoId");
            haveAddress = jsonObject.optBoolean("haveAddress");
            openId = jsonObject.optString("openId");
        } catch (Exception e) {
            PalmUtil.LOG.e(Log.getStackTraceString(e));
        }
    }

    protected PalmAccountInfo(Parcel in) {
        nickName = in.readString();
        userName = in.readString();
        avatarUrl = in.readString();
        phone = in.readString();
        birthday = in.readString();
        gender = in.readInt();
        state = in.readString();
        city = in.readString();
        country = in.readString();
        profession = in.readString();
        email = in.readString();
        states = in.readByte() != 0;
        existPassword = in.readByte() != 0;
        fullName = in.readString();
        signature = in.readString();
        usernameModifyRemainTimes = in.readInt();
        xuanniaoId = in.readString();
        haveAddress = in.readByte() != 0;
    }

    public static final Creator<PalmAccountInfo> CREATOR = new Creator<PalmAccountInfo>() {
        @Override
        public PalmAccountInfo createFromParcel(Parcel in) {
            return new PalmAccountInfo(in);
        }

        @Override
        public PalmAccountInfo[] newArray(int size) {
            return new PalmAccountInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(nickName);
        dest.writeString(userName);
        dest.writeString(avatarUrl);
        dest.writeString(phone);
        dest.writeString(birthday);
        dest.writeInt(gender);
        dest.writeString(state);
        dest.writeString(city);
        dest.writeString(country);
        dest.writeString(profession);
        dest.writeString(email);
        dest.writeByte((byte) (states ? 1 : 0));
        dest.writeByte((byte) (existPassword ? 1 : 0));
        dest.writeString(fullName);
        dest.writeString(signature);
        dest.writeInt(usernameModifyRemainTimes);
        dest.writeString(xuanniaoId);
        dest.writeByte((byte) (haveAddress ? 1 : 0));
    }
}
