package com.transsion.palmsdk.account;

import android.content.Context;

import hyperion.hap.IStoreManager;
import com.transsion.security.api.hap.TranStoreManagerLite;

/**
 * 使用Lite Tee存储敏感数据
 */
public class LiteTeeManager {

    private static LiteTeeManager sInstance;
    private final IStoreManager storeManager;

    private LiteTeeManager(Context context) {
        storeManager = TranStoreManagerLite.Companion.getInstance(context);
    }

    public static LiteTeeManager instance(Context context) {
        if (sInstance == null) {
            synchronized(LiteTeeManager.class) {
                if (sInstance == null) {
                    sInstance = new LiteTeeManager(context);
                }
            }
        }
        return sInstance;
    }

    public String getString(String key) {
        return storeManager.loadString(key);
    }

    public void saveString(String key, String value) {
        storeManager.saveString(key, value);
    }
}
