package com.transsion.palmsdk.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

/**
 * 当前已登录的PalmID账号
 */
public class PalmLoggedInfo implements Parcelable {

    private String nickName;

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getLoggedId() {
        return loggedId;
    }

    public void setLoggedId(String loggedId) {
        this.loggedId = loggedId;
    }

    public String getTargetApp() {
        return targetApp;
    }

    public void setTargetApp(String targetApp) {
        this.targetApp = targetApp;
    }

    private String userName;
    private String avatarUrl;
    private String loggedId;
    private String targetApp;

    public boolean isLogged() {
        return !TextUtils.isEmpty(loggedId);
    }

    public PalmLoggedInfo() { }


    protected PalmLoggedInfo(Parcel in) {
        nickName = in.readString();
        userName = in.readString();
        avatarUrl = in.readString();
        loggedId = in.readString();
        targetApp = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(nickName);
        dest.writeString(userName);
        dest.writeString(avatarUrl);
        dest.writeString(loggedId);
        dest.writeString(targetApp);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PalmLoggedInfo> CREATOR = new Creator<PalmLoggedInfo>() {
        @Override
        public PalmLoggedInfo createFromParcel(Parcel in) {
            return new PalmLoggedInfo(in);
        }

        @Override
        public PalmLoggedInfo[] newArray(int size) {
            return new PalmLoggedInfo[size];
        }
    };
}
