package com.transsion.palmsdk.tudc;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.transsion.palmsdk.util.PalmUtil;

import net.grandcentrix.tray.AppPreferences;

public class TudcAccount {

    private static TudcAccount sTudcAccount;
    private static final String TAG_TOKEN = "TOKEN";
    private static final String TAG_OPENID = "OPENID";
    private final String tudcSpName;
    private String token;
    private long openId;
    private AppPreferences appPreferences;

    private TudcAccount(String spName) {
        tudcSpName = spName;
    }

    public static TudcAccount getInstance(String spName) {
        if (sTudcAccount == null) {
            synchronized (TudcAccount.class) {
                if (sTudcAccount == null) {
                    sTudcAccount = new TudcAccount(spName);
                }
            }
        }
        return sTudcAccount;
    }

    /**
     * TUDC是否处于登录状态
     */
    public boolean isLogged(Context context) {
        if (TextUtils.isEmpty(tudcSpName)) {
            if (appPreferences == null) {
                appPreferences = new AppPreferences(context);
            }
            token = appPreferences.getString(TAG_TOKEN, "");
            openId = appPreferences.getLong(TAG_OPENID, 0);
        } else {
            SharedPreferences sp =
                    context.getSharedPreferences(tudcSpName, Context.MODE_PRIVATE);
            token = sp.getString("token", "");
            openId = sp.getLong("openid", 0);
        }
        return token.length() > 0 && openId > 0;
    }

    /**
     * 清理TUDC账号数据
     */
    public void clear(Context context) {
        if (TextUtils.isEmpty(token)) {
            return;
        }
        token = "";
        openId = 0;
        if (TextUtils.isEmpty(tudcSpName)) {
            if (appPreferences == null) {
                appPreferences = new AppPreferences(context);
            }
            appPreferences.remove(TAG_TOKEN);
            appPreferences.remove(TAG_OPENID);
        } else {
            SharedPreferences sp =
                    context.getSharedPreferences(tudcSpName, Context.MODE_PRIVATE);
            sp.edit().putString("token", "")
                    .putLong("openid", 0).apply();
        }
        PalmUtil.LOG.d("tudc token clear");
    }

    /**
     * 返回TUDC账号token
     */
    public String getTudcToken() {
        return token;
    }
}
