package com.transsion.palmsdk.account;

import android.app.Activity;
import android.content.Context;

import com.transsion.palmsdk.PalmID;

/**
 * @Description:
 * @author： 胡南 on 2021/5/10
 * =======================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class XNManager {

    public interface AccountProvider {

        void applyKey(Context context, String clientId, int serverMode);

        boolean isLogged(Context context);

        boolean refreshToken(Context context, String tudcToken,
                             PalmID.IPalmApiListener<String> apiListener);

        void setToken(Context context, String aToken, String rToken);

        String getToken();

        long getTokenExpiredTs(Context context);

        void getLoginRecord(Context context, int type,
                            PalmID.IPalmApiListener<String> apiListener);

        String getAccountInfo(Context context);

        void silentLogin(Context context, String requestId);

        void silentLogout(Context context, boolean force);

        void showBindPhoneDialog(Activity activity);
    }

    private AccountProvider accountProvider;

    private XNManager() {

    }

    static class XNManagerInner {
        static XNManager instance = new XNManager();
    }

    public static XNManager getInstance() {
        return XNManagerInner.instance;
    }

    public void setAccountProvider(AccountProvider provider) {
        accountProvider = provider;
    }

    public void applyKey(Context context, String clientId, int serverMode) {
        if (accountProvider != null) {
            accountProvider.applyKey(context, clientId, serverMode);
        }
    }

    public boolean isLogged(Context context) {
        if (accountProvider != null) {
            return accountProvider.isLogged(context);
        }
        return false;
    }

    public boolean refreshToken(Context context, String tudcToken,
                                PalmID.IPalmApiListener<String> apiListener) {
        if (accountProvider != null) {
            return accountProvider.refreshToken(context, tudcToken, apiListener);
        }
        return false;
    }

    public void setToken(Context context, String aToken, String rToken) {
        if (accountProvider != null) {
            accountProvider.setToken(context, aToken, rToken);
        }
    }

    public String getToken() {
        if (accountProvider != null) {
            return accountProvider.getToken();
        }
        return null;
    }

    public long getTokenExpiredTs(Context context) {
        if (accountProvider != null) {
            return accountProvider.getTokenExpiredTs(context);
        }
        return 0;
    }

    public void getLoginRecord(Context context, int type,
                               PalmID.IPalmApiListener<String> apiListener) {
        if (accountProvider != null) {
            accountProvider.getLoginRecord(context, type, apiListener);
        }
    }

    public String getAccountInfo(Context context) {
        if (accountProvider != null) {
            return accountProvider.getAccountInfo(context);
        }
        return null;
    }

    public void silentLogin(Context context, String requestId) {
        if (accountProvider != null) {
            accountProvider.silentLogin(context, requestId);
        }
    }

    public void silentLogout(Context context, boolean force) {
        if (accountProvider != null) {
            accountProvider.silentLogout(context, force);
        }
    }

    public void showBindPhoneDialog(Activity activity) {
        if (accountProvider != null) {
            accountProvider.showBindPhoneDialog(activity);
        }
    }
}