package com.transsion.palmsdk.auth;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.Nullable;

import com.transsion.palmsdk.PalmAuthParam;
import com.transsion.palmsdk.PalmConstants;
import com.transsion.palmsdk.data.PalmAuthRequest;
import com.transsion.palmsdk.util.PalmUtil;
import com.transsion.palmsdk.util.ThreadExecutors;

/**
 * 运行在palm app中，处理登录授权请求
 */
public class PalmAuthService extends Service {

    private Context mContext;

    private final IPalmAuthService.Stub mStub = new IPalmAuthService.Stub() {

        @Override
        public void authorize(Bundle param, IPalmAuthResponse response) throws RemoteException {
            try {
                param.setClassLoader(getClass().getClassLoader());
                PalmAuthParam palmAuthParam = param.getParcelable(PalmConstants.EXTRA_AUTH_PARAM);
                if (palmAuthParam == null) {
                    if (response != null) {
                        Bundle bundle = new Bundle();
                        bundle.putInt(PalmConstants.EXTRA_ERROR_CODE, PalmConstants.ERROR_ARGUMENT);
                        bundle.putString(PalmConstants.EXTRA_ERROR_MESSAGE, "invalid arguments");
                        response.setResult(bundle);
                    }
                    return;
                }
                PalmAuthRequest palmAuthRequest
                        = new PalmAuthRequest(palmAuthParam, false, response);
//                palmAuthRequest.setSilentMode(param.getBoolean(PalmConstants.EXTRA_SILENT_MODE));
                palmAuthRequest.setHostMode(param.getBoolean(PalmConstants.EXTRA_HOST_MODE, false));
                ThreadExecutors.getInstance().execute(new PalmAuthRunnable(palmAuthRequest));
            } catch (Exception e) {
                PalmUtil.LOG.e(Log.getStackTraceString(e));
            }
        }

        @Override
        public void getPalmStatus(Bundle param, IPalmAuthResponse response) throws RemoteException {
            try {
                param.setClassLoader(getClass().getClassLoader());
                PalmAuthParam palmAuthParam = param.getParcelable(PalmConstants.EXTRA_AUTH_PARAM);
                if (palmAuthParam == null) {
                    if (response != null) {
                        Bundle bundle = new Bundle();
                        bundle.putInt(PalmConstants.EXTRA_STATUS, PalmConstants.STATUS_CONNECT_FAIL);
                        response.setResult(bundle);
                    }
                    return;
                }
                ThreadExecutors.getInstance()
                        .execute(new PalmStatusRunnable(new PalmAuthRequest(palmAuthParam, false, response)));
            } catch (Exception e) {
                PalmUtil.LOG.e(Log.getStackTraceString(e));
            }
        }
    };

    /**
     * 一次登录/授权任务
     */
    private class PalmAuthRunnable implements Runnable {
        private final PalmAuthRequest palmAuthRequest;

        private PalmAuthRunnable(PalmAuthRequest palmAuthRequest) {
            this.palmAuthRequest = palmAuthRequest;
        }

        @Override
        public void run() {
            PalmAuthManager.getInstance(mContext).handleAuthRequest(palmAuthRequest);
        }
    }

    /**
     * 检查登录状态
     */
    private class PalmStatusRunnable implements Runnable {
        private final PalmAuthRequest palmAuthRequest;

        private PalmStatusRunnable(PalmAuthRequest palmAuthRequest) {
            this.palmAuthRequest = palmAuthRequest;
        }

        @Override
        public void run() {
            PalmAuthManager.getInstance(mContext).handleStatusRequest(palmAuthRequest);
        }
    }

    @Override
    public void onCreate() {
        mContext = getApplicationContext();
//        PalmUtil.LOG.getBuilder().setLogSwitch(true); // 打开日志
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
       return mStub;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        // 进程意外终止时不重新启动
        return START_NOT_STICKY; // super.onStartCommand(intent, flags, startId);
    }
}
