package com.transsion.palmsdk.data;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONObject;

/**
 * 标准OAUTH2.0访问code
 */
class PalmAuthCodeInfo extends PalmAuthInfo implements Parcelable {

    public String authCode;
    public String openid;

    protected PalmAuthCodeInfo(Parcel in) {
        authCode = in.readString();
    }

    public PalmAuthCodeInfo(String jsonData) {
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            authCode = jsonObject.optString("auth_code");
            openid = jsonObject.optString("open_id");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final Creator<PalmAuthCodeInfo> CREATOR = new Creator<PalmAuthCodeInfo>() {
        @Override
        public PalmAuthCodeInfo createFromParcel(Parcel in) {
            return new PalmAuthCodeInfo(in);
        }

        @Override
        public PalmAuthCodeInfo[] newArray(int size) {
            return new PalmAuthCodeInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(authCode);
        dest.writeString(openid);
    }
}
