package com.transsion.palmsdk.data;

import android.os.Bundle;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.transsion.palmsdk.PalmConstants;
import com.transsion.palmsdk.util.PalmUtil;

import org.json.JSONObject;

import java.io.Serializable;

/**
 * 授权结果
 */
public class PalmAuthResult implements Serializable {

    private PalmUserInfo userInfo;  // web方式授权为null
    private PalmAuthInfo authInfo;  // code or token

    public PalmAuthResult(Bundle bundle) {
        String userJson = bundle.getString(PalmConstants.EXTRA_USER_INFO);
        if (!TextUtils.isEmpty(userJson)) {
            if (userJson.contains("phone") || userJson.contains("email")) {
                userInfo = new PalmAccountInfo(userJson);
            } else {
                userInfo = new PalmUserInfo(userJson);
            }
        }
        String tokenJson = bundle.getString(PalmConstants.EXTRA_TOKEN_INFO);
        if (!TextUtils.isEmpty(tokenJson)) {
            if (tokenJson.contains("auth_code")) {
                authInfo = new PalmAuthCodeInfo(tokenJson);
            } else {
                authInfo = new PalmTokenInfo(tokenJson);
            }
        }
    }

    public PalmAuthResult(String token, String accountInfo) {
        String openId = null;
        if (!TextUtils.isEmpty(accountInfo)) {
            PalmAccountInfo accInfo = new PalmAccountInfo(accountInfo);
            openId = accInfo.openId;
            userInfo = accInfo;
        }
        try {
            authInfo = new PalmTokenInfo(new JSONObject()
                    .put("access_token", token)
                    .put("open_id", openId).toString());
        } catch (Exception e) {
//            e.printStackTrace();
        }
    }

    public String getOpenid() {
        if (authInfo instanceof PalmAuthCodeInfo) {
            return ((PalmAuthCodeInfo) authInfo).openid;
        }
        if (authInfo instanceof PalmTokenInfo) {
            return ((PalmTokenInfo) authInfo).openid;
        }
        return null;
    }

    public String getNickName() {
        return userInfo != null ? userInfo.nickName : null;
    }

    public String getAvatarUrl() {
        return userInfo != null ? userInfo.avatarUrl : null;
    }

    public String getUserName() {
        return userInfo != null ? userInfo.userName : null;
    }

    public String getAuthCode() {
        if (authInfo instanceof PalmAuthCodeInfo) {
            return ((PalmAuthCodeInfo) authInfo).authCode;
        }
        return null;
    }

    public String getAccessToken() {
        if (authInfo instanceof PalmTokenInfo) {
            return ((PalmTokenInfo) authInfo).access_token;
        }
        return null;
    }

    public String getRefreshToken() {
        if (authInfo instanceof PalmTokenInfo) {
            return ((PalmTokenInfo) authInfo).refresh_token;
        }
        return null;
    }

    public int getExpiresIn() {
        if (authInfo instanceof PalmTokenInfo) {
            return ((PalmTokenInfo) authInfo).expires_in;
        }
        return 0;
    }

    @NonNull
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (userInfo != null) {
            builder.append("userName = ").append(userInfo.userName).append(";")
                    .append("nickName = ").append(userInfo.nickName).append(";");
        }
        if (authInfo != null) {
            if (authInfo instanceof PalmAuthCodeInfo) {
                PalmAuthCodeInfo codeInfo = (PalmAuthCodeInfo) authInfo;
                builder.append("auth_code = ").append(codeInfo.authCode).append(";");
            } else {
                PalmTokenInfo tokenInfo = (PalmTokenInfo) authInfo;
                builder.append("access_token = ").append(tokenInfo.access_token).append(";");
            }
        }
        return builder.toString();
    }
}
