package com.transsion.palmsdk.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

import com.transsion.palmsdk.util.PalmUtil;

import org.json.JSONObject;

/**
 * 标准OAUTH2.0访问令牌
 */
public class PalmTokenInfo extends PalmAuthInfo implements Parcelable {

    public String access_token;
    public int expires_in;  // token有效期，单位秒
    public String refresh_token;
//    public String scope;
    public String openid;
    private long update_time;

    public PalmTokenInfo(String jsonData) {
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            if (jsonObject.has("token")) {
                access_token = jsonObject.optString("token");
                refresh_token = jsonObject.optString("refreshToken");
            } else {
                access_token = jsonObject.optString("access_token");
                refresh_token = jsonObject.optString("refresh_token");
                expires_in = jsonObject.optInt("expires_in", 7199);  // 兼容老版本SDK不返回expires_in字段
//                scope = jsonObject.optString("scope");
                openid = jsonObject.optString("open_id");
                update_time = jsonObject.optLong("update_time");
            }
        } catch (Exception e) {
            PalmUtil.LOG.e(Log.getStackTraceString(e));
        }
    }

    public PalmTokenInfo(PalmTokenInfo tokenInfo) {
        this.access_token = tokenInfo.access_token;
        this.expires_in = tokenInfo.expires_in;
        this.refresh_token = tokenInfo.refresh_token;
        this.openid = tokenInfo.openid;
        this.update_time = tokenInfo.update_time;
    }

    /**
     * 上一次更新时间
     */
    public long getLastUpdateTime() {
        return update_time;
    }

    /**
     * token有效时间
     */
    public long getExpireTime() {
        return expires_in * 1000L;
    }

    /**
     * 返回json格式数据
     */
    public String toJson() {
        try {
            return new JSONObject().put("access_token", access_token)
//                    .put("expires_in", expires_in)
                    .put("refresh_token", refresh_token)
//                    .put("scope", scope)
                    .put("open_id", openid).toString();
        } catch (Exception e) {
            PalmUtil.LOG.e(Log.getStackTraceString(e));
        }
        return null;
    }

    protected PalmTokenInfo(Parcel in) {
        access_token = in.readString();
//        expires_in = in.readString();
        refresh_token = in.readString();
//        scope = in.readString();
        openid = in.readString();
    }

    public static final Creator<PalmTokenInfo> CREATOR = new Creator<PalmTokenInfo>() {
        @Override
        public PalmTokenInfo createFromParcel(Parcel in) {
            return new PalmTokenInfo(in);
        }

        @Override
        public PalmTokenInfo[] newArray(int size) {
            return new PalmTokenInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(access_token);
//        dest.writeString(expires_in);
        dest.writeString(refresh_token);
//        dest.writeString(scope);
        dest.writeString(openid);
    }
}
