/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.accessibilityservice.TranAospAccessibilityServiceInfoManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.accessibilityservice.TranThubAccessibilityServiceInfoManager;
import com.transsion.hubsdk.interfaces.accessibilityservice.ITranAccessibilityServiceInfoManagerAdapter;

public class TranAccessibilityServiceInfoManager {
    private static final String TAG = TranAccessibilityServiceInfoManager.class.getSimpleName();
    private ITranAccessibilityServiceInfoManagerAdapter mService;
    private TranContext mTranContext;

    public TranAccessibilityServiceInfoManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            this.mService = new TranThubAccessibilityServiceInfoManager();
        } else {
            this.mService = new TranAospAccessibilityServiceInfoManager();
            TranSdkLog.i((String)TAG, (String)"TranAccessibilityServiceInfoManager");
        }
    }

    public boolean getCrashed(AccessibilityServiceInfo serviceInfo) {
        boolean isCrashed = false;
        if (this.mService != null) {
            try {
                isCrashed = this.mService.getCrashed(serviceInfo);
            }
            catch (Exception e) {
                TranSdkLog.e((String)TAG, (String)("getCrashed:" + e));
            }
        }
        return isCrashed;
    }
}

