/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.app;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.graphics.Rect;
import android.util.Log;
import android.view.SurfaceControl;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.app.TranAospActivityTaskManager;
import com.transsion.hubsdk.app.ITranActivityController;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.app.TranThubActivityTaskManager;
import com.transsion.hubsdk.interfaces.app.ITranActivityTaskManagerAdapter;
import java.util.List;

public class TranActivityTaskManager {
    private static final String TAG = TranActivityTaskManager.class.getSimpleName();
    private ITranActivityTaskManagerAdapter mService;
    private TranContext mTranContext;

    public TranActivityTaskManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            this.mService = new TranThubActivityTaskManager();
            TranSdkLog.i((String)TAG, (String)"TranThubActivityTaskManager");
        } else {
            this.mService = new TranAospActivityTaskManager();
            TranSdkLog.i((String)TAG, (String)"TranAospActivityTaskManager");
        }
    }

    public void setService(ITranActivityTaskManagerAdapter service) {
        this.mService = service;
    }

    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags, int userId) {
        try {
            return this.mService.getRecentTasks(maxNum, flags, userId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<ActivityManager.RunningTaskInfo> getTasks(int maxNum, boolean filterOnlyVisibleRecents, boolean keepIntentExtra) {
        return this.mService.getTasks(maxNum, filterOnlyVisibleRecents, keepIntentExtra);
    }

    public ComponentName getTopActivityComponent() {
        Log.i((String)TAG, (String)"tran getTopActivityComponent");
        return this.mService.getTopActivityComponent();
    }

    public void setThreadScheduler(int tid, int policy, int priority) {
        Log.i((String)TAG, (String)"tran setThreadScheduler");
        this.mService.setThreadScheduler(tid, policy, priority);
    }

    public boolean removeTask(int taskId) {
        Log.i((String)TAG, (String)"tran removeTask");
        return this.mService.removeTask(taskId);
    }

    public int getLockTaskModeState() {
        return this.mService.getLockTaskModeState();
    }

    public String getFocusedWinPkgName() {
        Log.i((String)TAG, (String)"tran getFocusedWinPkgName");
        return this.mService.getFocusedWinPkgName();
    }

    public boolean isSecureWindow() {
        Log.i((String)TAG, (String)"tran isSecureWindow");
        return this.mService.isSecureWindow();
    }

    public boolean isIMEShowing() {
        Log.i((String)TAG, (String)"tran isIMEShowing");
        return this.mService.isIMEShowing();
    }

    public boolean inMultiWindowMode() {
        Log.i((String)TAG, (String)"tran inMultiWindowMode");
        return this.mService.inMultiWindowMode();
    }

    public void notifyKeyguardGoingAwayQuickly(boolean goingAwayQuickly) {
        this.mService.notifyKeyguardGoingAwayQuickly(goingAwayQuickly);
    }

    public int getLastResumedActivityUserId() {
        return this.mService.getLastResumedActivityUserId();
    }

    public void setMultiWindowAcquireFocuse() {
        this.mService.setMultiWindowAcquireFocuse();
    }

    public void hookMultiWindowVisible() {
        this.mService.hookMultiWindowVisible();
    }

    public void hookMultiWindowInvisible() {
        this.mService.hookMultiWindowInvisible();
    }

    public void hookStartActivityResult(int result, Rect location) {
        this.mService.hookStartActivityResult(result, location);
    }

    public void setTranMultiWindowMode(int mode) {
        this.mService.setTranMultiWindowMode(mode);
    }

    public Rect getMultiWindowDefaultRect() {
        return this.mService.getMultiWindowDefaultRect();
    }

    public void setStartInMultiWindow(String pkgName, int type, int direction, int startType) {
        this.mService.setStartInMultiWindow(pkgName, type, direction, startType);
    }

    public void setMultiWindowBlackListToSystem(List<String> list) {
        this.mService.setMultiWindowBlackListToSystem(list);
    }

    public void setMultiWindowWhiteListToSystem(List<String> list) {
        this.mService.setMultiWindowWhiteListToSystem(list);
    }

    public String getMultiWindowVersion() {
        return this.mService.getMultiWindowVersion();
    }

    public List<String> getMultiWindowBlackList() {
        return this.mService.getMultiWindowBlackList();
    }

    public boolean hasMultiWindow() {
        return this.mService.hasMultiWindow();
    }

    public boolean activityInMultiWindow(String pkgName) {
        return this.mService.activityInMultiWindow(pkgName);
    }

    public String getMulitWindowTopPackage() {
        return this.mService.getMulitWindowTopPackage();
    }

    public void startCurrentAppInMultiWindow(boolean anim, int startType) {
        this.mService.startCurrentAppInMultiWindow(anim, startType);
    }

    public boolean isSupportMultiWindow() {
        return this.mService.isSupportMultiWindow();
    }

    public void setFinishFixedRotationEnterMultiWindowTransaction(SurfaceControl leash, int x, int y, int rotation, float scale) {
        this.mService.setFinishFixedRotationEnterMultiWindowTransaction(leash, x, y, rotation, scale);
    }

    public SurfaceControl getWeltWindowLeash(int width, int height, int x, int y, boolean hidden) {
        return this.mService.getWeltWindowLeash(width, height, x, y, hidden);
    }

    public void removeWeltWindowLeash(SurfaceControl leash) {
        this.mService.removeWeltWindowLeash(leash);
    }

    public void hookActiveMultiWindowMoveStart() {
        this.mService.hookActiveMultiWindowMoveStart();
    }

    public boolean checkMultiWindowFeatureOn() {
        return this.mService.checkMultiWindowFeatureOn();
    }

    public boolean getMuteState() {
        return this.mService.getMuteState();
    }

    public void setMuteState(boolean state) {
        this.mService.setMuteState(state);
    }

    public String getMultiDisplayAreaTopPackage() {
        return this.mService.getMultiDisplayAreaTopPackage();
    }

    public void setActivityController(ITranActivityController controller, boolean imAMonkey) {
        this.mService.setActivityController(controller, imAMonkey);
    }
}

