/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.app;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.content.ComponentName;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.app.TranAospNotificationManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.content.pm.TranParceledListSlice;
import com.transsion.hubsdk.core.app.TranThubNotificationManager;
import com.transsion.hubsdk.interfaces.app.ITranNotificationManagerAdapter;

public class TranNotificationManager {
    private static final String TAG = TranNotificationManager.class.getSimpleName();
    private ITranNotificationManagerAdapter mService;
    private TranContext mTranContext;

    public TranNotificationManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            this.mService = new TranThubNotificationManager();
            TranSdkLog.i((String)TAG, (String)"TranThubNotificationManager");
        } else {
            this.mService = new TranAospNotificationManager();
            TranSdkLog.i((String)TAG, (String)"TranAospNotificationManager");
        }
    }

    public void setNotificationListenerAccessGranted(ComponentName listener, boolean granted, boolean userSet) {
        if (this.mService != null) {
            this.mService.setNotificationListenerAccessGranted(listener, granted, userSet);
        }
    }

    public void updateNotificationChannel(String pkg, int uid, NotificationChannel channel) {
        if (this.mService != null) {
            this.mService.updateNotificationChannel(pkg, uid, channel);
        }
    }

    public boolean areNotificationsEnabledForPackage(String pkg, int uid) {
        if (this.mService != null) {
            return this.mService.areNotificationsEnabledForPackage(pkg, uid);
        }
        return false;
    }

    public NotificationChannel getNotificationChannelForPackage(String pkg, int uid, String channelId, String conversationId, boolean includeDeleted) {
        if (this.mService != null) {
            return this.mService.getNotificationChannelForPackage(pkg, uid, channelId, conversationId, includeDeleted);
        }
        return null;
    }

    public boolean onlyHasDefaultChannel(String pkg, int uid) {
        if (this.mService != null) {
            return this.mService.onlyHasDefaultChannel(pkg, uid);
        }
        return false;
    }

    public void setNotificationsEnabledForPackage(String pkg, int uid, boolean enabled) {
        if (this.mService != null) {
            this.mService.setNotificationsEnabledForPackage(pkg, uid, enabled);
        }
    }

    public void setShowBadge(String pkg, int uid, boolean showBadge) {
        if (this.mService != null) {
            this.mService.setShowBadge(pkg, uid, showBadge);
        }
    }

    public boolean canShowBadge(String pkg, int uid) {
        if (this.mService != null) {
            return this.mService.canShowBadge(pkg, uid);
        }
        return false;
    }

    public TranParceledListSlice<NotificationChannelGroup> getNotificationChannelGroupsForPackage(String pkg, int uid, boolean includeDeleted) {
        if (this.mService != null) {
            return this.mService.getNotificationChannelGroupsForPackage(pkg, uid, includeDeleted);
        }
        return null;
    }
}

