/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.appm;

import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.appm.TranAospAppmServiceManager;
import com.transsion.hubsdk.appm.ITranAppmCallback;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.appm.TranThubAppmServiceManager;
import com.transsion.hubsdk.interfaces.appm.ITranAppmServiceManagerAdapter;

public class TranAppmServiceManager {
    private static final String TAG = TranAppmServiceManager.class.getSimpleName();
    private TranContext mTranContext;
    private ITranAppmServiceManagerAdapter mService;

    public TranAppmServiceManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            this.mService = new TranThubAppmServiceManager();
            TranSdkLog.i((String)TAG, (String)"TranThubAppmServiceManager");
        } else {
            this.mService = new TranAospAppmServiceManager();
            TranSdkLog.i((String)TAG, (String)"TranAospAppmServiceManager");
        }
    }

    public void sendEvent(String key, String value) {
        if (this.mService == null) {
            throw new NullPointerException("TranAppmService is Null");
        }
        this.mService.sendEvent(key, value);
    }

    public void registerAppmCallback(ITranAppmCallback callback) {
        if (this.mService == null) {
            throw new NullPointerException("TranAppmService is Null");
        }
        this.mService.registerAppmCallback(callback);
    }

    public void unregisterAppmCallback(ITranAppmCallback callback) {
        if (this.mService == null) {
            throw new NullPointerException("TranAppmService is Null");
        }
        this.mService.unregisterAppmCallback(callback);
    }

    public String getPolicyVersion(String key) {
        if (this.mService == null) {
            return "unkown";
        }
        return this.mService.getPolicyVersion(key);
    }

    public void notifyClient(String key, String value) {
        if (this.mService == null) {
            throw new NullPointerException("TranAppmService is Null");
        }
        this.mService.notifyClient(key, value);
    }
}

