/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.hardware.input;

import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.hardware.input.TranAospInputManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.hardware.input.TranThubInputManager;
import com.transsion.hubsdk.interfaces.hardware.input.ITranInputManagerAdapter;
import com.transsion.hubsdk.view.ITranInputMonitor;
import com.transsion.hubsdk.view.ITranTouchEventHandler;

public class TranInputManager {
    private static final String TAG = TranInputManager.class.getSimpleName();
    private ITranInputManagerAdapter mService;
    private TranContext mTranContext;

    public TranInputManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            this.mService = new TranThubInputManager();
        } else {
            this.mService = new TranAospInputManager();
            TranSdkLog.i((String)TAG, (String)"TranInputManager");
        }
    }

    public ITranInputMonitor monitorGestureInput(String name, int displayId, ITranTouchEventHandler touchEventHandler) {
        if (this.mService != null) {
            try {
                return this.mService.monitorGestureInput(name, displayId, touchEventHandler);
            }
            catch (Exception e) {
                TranSdkLog.e((String)TAG, (String)("monitorGestureInput:" + e));
            }
        }
        return null;
    }
}

