/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.net;

import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.net.TranAospConnectivityManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.net.TranThubConnectivityManager;
import com.transsion.hubsdk.interfaces.net.ITranConnectivityManagerAdapter;
import com.transsion.hubsdk.net.ITranOnStartTetheringCallback;

public class TranConnectivityManager {
    private static final String TAG = TranConnectivityManager.class.getSimpleName();
    private final ITranConnectivityManagerAdapter mService;
    private final TranContext mTranContext;

    public TranConnectivityManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33111")) {
            this.mService = new TranThubConnectivityManager();
            TranSdkLog.i((String)TAG, (String)"TranThubConnectivityManager");
        } else {
            this.mService = new TranAospConnectivityManager();
            TranSdkLog.i((String)TAG, (String)"TranAospConnectivityManager");
        }
    }

    public void startTethering(int type, boolean showProvisioningUi, ITranOnStartTetheringCallback callback) {
        this.mService.startTethering(type, showProvisioningUi, callback);
    }

    public void stopTethering(int type) {
        this.mService.stopTethering(type);
    }
}

