/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.os;

import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.os.TranAospSystemProperties;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.os.TranThubSystemProperties;
import com.transsion.hubsdk.interfaces.os.ITranSystemPropertiesAdapter;

public class TranSystemProperties {
    private static final String TAG = TranSystemProperties.class.getSimpleName();
    private static ITranSystemPropertiesAdapter mSystemProperties;
    private TranContext mTranContext;

    public TranSystemProperties(TranContext tranContext) {
        this.mTranContext = tranContext;
    }

    public static String get(String key) {
        String value = "";
        try {
            value = mSystemProperties.get(key, value);
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("getMethod:" + e));
        }
        return value;
    }

    public static String get(String key, String defaultValue) {
        String value = defaultValue;
        try {
            value = mSystemProperties.get(key, value);
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("getWithDefaultMethod:" + e));
        }
        return value;
    }

    public static int getInt(String key, int defaultValue) {
        int value = defaultValue;
        try {
            value = mSystemProperties.getInt(key, value);
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("getIntMethod:" + e));
        }
        return value;
    }

    public static long getLong(String key, long defaultValue) {
        long value = defaultValue;
        try {
            value = mSystemProperties.getLong(key, value);
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("getLongMethod:" + e));
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            value = mSystemProperties.getBoolean(key, value);
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("getBooleanMethod:" + e));
        }
        return value;
    }

    public static void set(String key, String val) {
        try {
            mSystemProperties.set(key, val);
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("setMethod:" + e));
        }
    }

    static {
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            mSystemProperties = new TranThubSystemProperties();
            TranSdkLog.i((String)TAG, (String)"TranThubSystemProperties");
        } else {
            mSystemProperties = new TranAospSystemProperties();
            TranSdkLog.i((String)TAG, (String)"TranAospSystemProperties");
        }
    }
}

