/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.os;

import com.transsion.hubsdk.aosp.os.TranAospTraceManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.os.TranThubTraceManager;
import com.transsion.hubsdk.interfaces.os.ITranTraceManagerAdapter;

public class TranTraceManager {
    private static final String TAG = TranTraceManager.class.getSimpleName();
    private final ITranTraceManagerAdapter mService;

    public TranTraceManager() {
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            this.mService = new TranThubTraceManager();
            TranSdkLog.i((String)TAG, (String)"TranThubTraceManager");
        } else {
            this.mService = new TranAospTraceManager();
            TranSdkLog.i((String)TAG, (String)"TranAospTraceManager");
        }
    }

    public void traceBegin(long traceTag, String methodName) {
        if (this.mService == null) {
            throw new NullPointerException("TranTraceService is Null");
        }
        this.mService.traceBegin(traceTag, methodName);
    }

    public void traceEnd(long traceTag) {
        if (this.mService == null) {
            throw new NullPointerException("TranTraceService is Null");
        }
        this.mService.traceEnd(traceTag);
    }
}

