/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.os;

import android.os.IBinder;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.content.pm.TranUserInfo;
import com.transsion.hubsdk.os.ITranUserManager;
import com.transsion.hubsdk.util.TranLog;

public class TranUserManager {
    private static final String TAG = TranUserManager.class.getSimpleName();
    private static ITranUserManager mService;
    private TranContext mTranContext;

    public TranUserManager(TranContext tranContext) {
        this.mTranContext = tranContext;
    }

    public TranUserInfo getUserInfo(int userId) {
        if (mService == null) {
            return null;
        }
        try {
            TranUserInfo userinfo = mService.getUserInfo(userId);
            TranLog.e((String)TAG, (String)("userinfo = " + userinfo));
            return userinfo;
        }
        catch (Exception e) {
            TranLog.e((String)TAG, (String)("getMethod:" + e));
            return null;
        }
    }

    public int getCredentialOwnerProfile(int userId) {
        if (mService == null) {
            return 0;
        }
        try {
            return mService.getCredentialOwnerProfile(userId);
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("getCredentialOwnerProfile:" + e));
            return 0;
        }
    }

    public int[] getProfileIdsWithDisabled(int userId) {
        if (mService == null) {
            return null;
        }
        try {
            return mService.getProfileIdsWithDisabled(userId);
        }
        catch (Exception e) {
            TranSdkLog.e((String)TAG, (String)("getCredentialOwnerProfile:" + e));
            return null;
        }
    }

    static {
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"user_manager");
            mService = ITranUserManager.Stub.asInterface((IBinder)serviceIBinder);
        }
    }
}

