/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.telephony;

import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.telephony.TranAospTelephonyManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.telephony.TranThubTelephonyManager;
import com.transsion.hubsdk.interfaces.telephony.ITranTelephonyManagerAdapter;
import com.transsion.hubsdk.telephony.TranServiceState;

public class TranTelephonyManager {
    private static final String TAG = TranTelephonyManager.class.getSimpleName();
    private static ITranTelephonyManagerAdapter mService;
    private TranContext mTranContext;

    public TranTelephonyManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            mService = new TranThubTelephonyManager();
            TranSdkLog.i((String)TAG, (String)"TranThubTelephonyManager");
        } else {
            mService = new TranAospTelephonyManager();
            TranSdkLog.i((String)TAG, (String)"TranAospTelephonyManager");
        }
    }

    public boolean setAllowedNetworkTypesForReason(int subId, int reason, long allowedNetworkTypes) {
        if (mService == null) {
            return false;
        }
        return mService.setAllowedNetworkTypesForReason(subId, reason, allowedNetworkTypes);
    }

    public void setPreferredNetworkType(int phoneId, long networkType) {
        if (mService == null) {
            return;
        }
        mService.setPreferredNetworkType(phoneId, networkType);
    }

    public boolean setRadioForSubscriber(int subId, boolean turnOn) {
        if (mService == null) {
            return false;
        }
        boolean res = mService.setRadioForSubscriber(subId, turnOn);
        return res;
    }

    public boolean isRadioOnForSubscriber(int subId, String callingPackage) {
        if (mService == null) {
            return false;
        }
        return mService.isRadioOnForSubscriber(subId, callingPackage);
    }

    public TranServiceState getServiceState() {
        if (mService == null) {
            return null;
        }
        return mService.getServiceState();
    }

    public void setDataEnabled(boolean enable) {
        if (mService == null) {
            return;
        }
        mService.setDataEnabled(enable);
    }

    public boolean getDataEnabled() {
        if (mService == null) {
            return false;
        }
        return mService.getDataEnabled();
    }

    public int getRadioPowerState() {
        return mService.getRadioPowerState();
    }

    public int getSimCount() {
        return mService.getSimCount();
    }

    public int getSimState() {
        return mService.getSimState();
    }

    public int getSimStateSlotIndex(int slotIndex) {
        return mService.getSimStateSlotIndex(slotIndex);
    }
}

